/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.config;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.RRElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class StaticConfiguration
extends RRElement {
    private static StaticConfiguration instance = null;
    private StaticConfigurationDao item = new StaticConfigurationDao();
    private RRContext context = null;
    private Map<String, Set<String>> presentationInfoKeywords = null;
    private static final String KeyValueDelimiter = "##scdelim##";
    public static final String SemanticGroupName = "semantic";
    private static String instanceID = null;
    private static long lastValidIteration = -1L;

    private StaticConfiguration() throws ResourceRegistryException {
        this.item.setID(UUID.randomUUID().toString());
        this.context = ResourceRegistry.getContext();
    }

    public static StaticConfiguration getInstance() throws ResourceRegistryException {
        if (!ResourceRegistry.isInitialBridgingComplete()) {
            throw new ResourceRegistryException("Initial bridging is not complete");
        }
        if (instance == null) {
            instance = new StaticConfiguration();
            instance.load(true);
            lastValidIteration = ResourceRegistry.getCurrentIteration();
            instanceID = instance.getID();
        }
        if (lastValidIteration < ResourceRegistry.getCurrentIteration()) {
            instance.load(true);
        }
        return instance;
    }

    public String getID() {
        return this.item.getID();
    }

    public void setID(String id) {
        this.item.setID(id);
    }

    public RRContext getISContext() {
        return this.context;
    }

    private void refresh() throws ResourceRegistryException {
        if (lastValidIteration < ResourceRegistry.getCurrentIteration()) {
            this.presentationInfoKeywords = null;
            instance.load(true);
        }
    }

    public Set<String> getPresentationInfoGroups() throws ResourceRegistryException {
        if (this.presentationInfoKeywords == null) {
            this.buildPresentationInfoKeywords();
        }
        return new HashSet<String>(this.presentationInfoKeywords.keySet());
    }

    public void addPresentationInfoGroup(String group) throws ResourceRegistryException {
        if (this.presentationInfoKeywords == null) {
            this.buildPresentationInfoKeywords();
        }
        if (this.presentationInfoKeywords.containsKey(group)) {
            throw new ResourceRegistryException("Presentation info keyword group \"" + group + "\" already exists");
        }
        this.presentationInfoKeywords.put(group, new HashSet());
    }

    public void deletePresentationInfoGroup(String group) throws ResourceRegistryException {
        if (this.presentationInfoKeywords == null) {
            this.buildPresentationInfoKeywords();
        }
        if (!this.presentationInfoKeywords.containsKey(group)) {
            throw new ResourceRegistryException("Presentation info keyword group \"" + group + "\" does not exist");
        }
        if (!this.presentationInfoKeywords.get(group).isEmpty()) {
            throw new ResourceRegistryException("Non-empty presentation info keyword group \"" + group + "\"; cannot delete");
        }
        this.presentationInfoKeywords.remove(group);
    }

    public Set<String> getPresentationInfoKeywords(String group) {
        if (this.presentationInfoKeywords == null) {
            this.buildPresentationInfoKeywords();
        }
        if (!this.presentationInfoKeywords.containsKey(group)) {
            return new HashSet<String>();
        }
        return new HashSet<String>((Collection)this.presentationInfoKeywords.get(group));
    }

    public void addPresentationInfoKeyword(String group, String keyword) throws ResourceRegistryException {
        if (this.presentationInfoKeywords == null) {
            this.buildPresentationInfoKeywords();
        }
        if (!this.presentationInfoKeywords.containsKey(group)) {
            throw new ResourceRegistryException("Presentation info keyword group \"" + group + "\" not found");
        }
        if (this.presentationInfoKeywords.get(group).contains(keyword)) {
            throw new ResourceRegistryException("Presentation info keyword group \"" + group + "\" already contains keyword");
        }
        this.presentationInfoKeywords.get(group).add(keyword);
    }

    public void deletePresentationInfoKeyword(String group, String keyword) throws ResourceRegistryException {
        if (this.presentationInfoKeywords == null) {
            this.buildPresentationInfoKeywords();
        }
        if (!this.presentationInfoKeywords.containsKey(group)) {
            throw new ResourceRegistryException("Presentable info keyword group " + group + " not found");
        }
        if (!this.presentationInfoKeywords.get(group).contains(keyword)) {
            throw new ResourceRegistryException("Presentation info keyword \"" + keyword + "\" was not found in group \"" + group + "\"");
        }
        this.presentationInfoKeywords.get(group).remove(keyword);
    }

    private void buildPresentationInfoKeywords() {
        this.presentationInfoKeywords = new HashMap<String, Set<String>>();
        for (String k : this.item.getPresentationInfoGroups()) {
            if (!this.presentationInfoKeywords.containsKey(k)) {
                this.presentationInfoKeywords.put(k, new HashSet());
            }
            for (String v : this.item.getPresentationInfoKeywords()) {
                String[] keyVal = v.split(KeyValueDelimiter);
                if (keyVal.length != 2 || !keyVal[0].trim().equals(k)) continue;
                this.presentationInfoKeywords.get(k).add(keyVal[1]);
            }
        }
    }

    public StaticConfigurationDao getItem() {
        return this.item;
    }

    public void setDirty() {
        this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
    }

    private void apply(IRRElement target, RRContext.DatastoreType persistencyType, boolean applyDetails, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof StaticConfiguration)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setID(((StaticConfiguration)target).item.getID());
        this.item.setPresentationInfoGroups(((StaticConfiguration)target).item.getPresentationInfoGroups());
        this.item.setPresentationInfoKeywords(((StaticConfiguration)target).item.getPresentationInfoKeywords());
        HashSet<String> toAddGroups = new HashSet<String>();
        for (String group : ((StaticConfiguration)target).item.getPresentationInfoGroups()) {
            if (this.getPresentationInfoGroups().contains(group)) continue;
            toAddGroups.add(group);
        }
        for (String group : toAddGroups) {
            this.addPresentationInfoGroup(group);
            this.item.getPresentationInfoGroups().add(group);
        }
        HashMap toDelKeywords = new HashMap();
        HashMap toAddKeywords = new HashMap();
        for (String string : this.getPresentationInfoGroups()) {
            for (String keyword : this.getPresentationInfoKeywords(string)) {
                if (((StaticConfiguration)target).getPresentationInfoKeywords(string).contains(keyword)) continue;
                if (!toDelKeywords.containsKey(string)) {
                    toDelKeywords.put(string, new HashSet());
                }
                ((Set)toDelKeywords.get(string)).add(keyword);
            }
        }
        for (String string : ((StaticConfiguration)target).getPresentationInfoGroups()) {
            for (String keyword : ((StaticConfiguration)target).getPresentationInfoKeywords(string)) {
                if (this.getPresentationInfoKeywords(string).contains(keyword)) continue;
                if (!toAddKeywords.containsKey(string)) {
                    toAddKeywords.put(string, new HashSet());
                }
                ((Set)toAddKeywords.get(string)).add(keyword);
            }
        }
        for (Map.Entry entry : toDelKeywords.entrySet()) {
            for (String keyword : (Set)entry.getValue()) {
                this.deletePresentationInfoKeyword((String)entry.getKey(), keyword);
                this.item.getPresentationInfoKeywords().remove((String)entry.getKey() + KeyValueDelimiter + keyword);
            }
        }
        for (Map.Entry entry : toAddKeywords.entrySet()) {
            for (String keyword : (Set)entry.getValue()) {
                this.addPresentationInfoKeyword((String)entry.getKey(), keyword);
                this.item.getPresentationInfoKeywords().add((String)entry.getKey() + KeyValueDelimiter + keyword);
            }
        }
        HashSet<String> toDelGroups = new HashSet<String>();
        for (String group : this.getPresentationInfoGroups()) {
            if (((StaticConfiguration)target).getPresentationInfoGroups().contains(group)) continue;
            toDelGroups.add(group);
        }
        for (String group : toDelGroups) {
            this.deletePresentationInfoGroup(group);
            this.item.getPresentationInfoGroups().remove(group);
        }
        if (doStore) {
            this.store(applyDetails, persistencyType, true);
        }
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.load(loadDetails, persistencyType, false);
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType, boolean overridePrefetched) throws ResourceRegistryException {
        PersistenceManager pm = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        try {
            Set items = DatastoreHelper.getItems((RRContext.DatastoreType)persistencyType, StaticConfigurationDao.class, (boolean)true);
            if (items.size() > 1) {
                throw new ResourceRegistryException("More than instance of static configuration was found!");
            }
            if (items.size() == 0) {
                throw new ResourceRegistryException("No static configuration instance was found");
            }
            this.setID(((IDaoElement)items.iterator().next()).getID());
            if (!overridePrefetched && persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    StaticConfiguration retrieved = (StaticConfiguration)InMemoryStore.getItem(((Object)((Object)this)).getClass(), (String)this.getID());
                    this.apply((IRRElement)retrieved, persistencyType, true, false);
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = this.getISContext().getManagerForRead(persistencyType);
            sharedLock.lock();
            locked = true;
            pm.currentTransaction().begin();
            this.item = (StaticConfigurationDao)pm.detachCopy(pm.getObjectById(StaticConfigurationDao.class, (Object)this.item.getID()));
            pm.currentTransaction().commit();
            sharedLock.unlock();
            locked = false;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not load static configuration", (Throwable)e);
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return true;
    }

    public void delete(boolean deleteDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        throw new ResourceRegistryException("This element does not support deletion");
    }

    public void store(boolean storeDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(boolean storeDetails, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (!this.getID().equals(instanceID)) {
            throw new ResourceRegistryException("Attempt to store duplicate static configuration. This object is a singleton");
        }
        if (this.exists(persistencyType) && !writeThrough) {
            StaticConfiguration item = new StaticConfiguration();
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, persistencyType, storeDetails, true);
        } else {
            this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                InMemoryStore.setItem(((Object)((Object)this)).getClass(), (IRRElement)this);
            }
            PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
            try {
                pm.currentTransaction().begin();
                this.item = (StaticConfigurationDao)pm.detachCopy(pm.makePersistent((Object)this.item));
                pm.currentTransaction().commit();
                pm.flush();
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
        }
    }

    public boolean isEqual(IRRElement target, boolean includeDetails) throws ResourceRegistryException {
        if (!(target instanceof StaticConfiguration)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.item.getID() == null && ((StaticConfiguration)target).item.getID() != null) {
            return false;
        }
        if (this.item.getID() != null && ((StaticConfiguration)target).item.getID() == null) {
            return false;
        }
        if (this.item.getID() != null && ((StaticConfiguration)target).item.getID() != null && !this.item.getID().equals(((StaticConfiguration)target).item.getID())) {
            return false;
        }
        if (this.getPresentationInfoGroups().size() != ((StaticConfiguration)target).getPresentationInfoGroups().size()) {
            return false;
        }
        if (!this.getPresentationInfoGroups().containsAll(((StaticConfiguration)target).getPresentationInfoGroups())) {
            return false;
        }
        for (String group : this.getPresentationInfoGroups()) {
            if (this.getPresentationInfoKeywords(group).size() != ((StaticConfiguration)target).getPresentationInfoKeywords(group).size()) {
                return false;
            }
            if (this.getPresentationInfoKeywords(group).containsAll(((StaticConfiguration)target).getPresentationInfoKeywords(group))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(StaticConfigurationDao.class, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", this.getID());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }
}

