/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ntlm;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.security.ntlm.Netlogon;
import com.liferay.portal.security.ntlm.NtlmLogonException;
import com.liferay.portal.security.ntlm.NtlmServiceAccount;
import com.liferay.portal.security.ntlm.NtlmUserAccount;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Encdec;

public class NtlmManager {
    private static final int _NTLMSSP_NEGOTIATE_EXTENDED_SESSION_SECURITY = 524288;
    private String _domain;
    private String _domainController;
    private String _domainControllerName;
    private Netlogon _netlogon;
    private NtlmServiceAccount _ntlmServiceAccount;

    public NtlmManager(String domain, String domainController, String domainControllerName, String serviceAccount, String servicePassword) {
        this.setConfiguration(domain, domainController, domainControllerName, serviceAccount, servicePassword);
    }

    public NtlmUserAccount authenticate(byte[] material, byte[] serverChallenge) throws IOException, NoSuchAlgorithmException, NtlmLogonException {
        Type3Message type3Message = new Type3Message(material);
        if (type3Message.getFlag(524288) && type3Message.getNTResponse().length == 24) {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[16];
            System.arraycopy(serverChallenge, 0, bytes, 0, 8);
            System.arraycopy(type3Message.getLMResponse(), 0, bytes, 8, 8);
            messageDigest.update(bytes);
            serverChallenge = messageDigest.digest();
        }
        return this._netlogon.logon(type3Message.getDomain(), type3Message.getUser(), type3Message.getWorkstation(), serverChallenge, type3Message.getNTResponse(), type3Message.getLMResponse());
    }

    public String getDomain() {
        return this._domain;
    }

    public String getDomainController() {
        return this._domainController;
    }

    public String getDomainControllerName() {
        return this._domainControllerName;
    }

    public String getServiceAccount() {
        return this._ntlmServiceAccount.getAccount();
    }

    public String getServicePassword() {
        return this._ntlmServiceAccount.getPassword();
    }

    public byte[] negotiate(byte[] material, byte[] serverChallenge) throws IOException {
        Type1Message type1Message = new Type1Message(material);
        Type2Message type2Message = new Type2Message(type1Message.getFlags(), serverChallenge, this._domain);
        if (type2Message.getFlag(524288)) {
            type2Message.setFlag(128, false);
            type2Message.setFlag(0x800000, true);
            type2Message.setTargetInformation(this.getTargetInformation());
        }
        return type2Message.toByteArray();
    }

    public void setConfiguration(String domain, String domainController, String domainControllerName, String serviceAccount, String servicePassword) {
        this._domain = domain;
        this._domainController = domainController;
        this._domainControllerName = domainControllerName;
        this._ntlmServiceAccount = new NtlmServiceAccount(serviceAccount, servicePassword);
        this._netlogon = new Netlogon();
        this._netlogon.setConfiguration(domainController, domainControllerName, this._ntlmServiceAccount);
    }

    protected byte[] getAVPairBytes(int avId, String value) throws UnsupportedEncodingException {
        byte[] valueBytes = value.getBytes("UTF-16LE");
        byte[] avPairBytes = new byte[4 + valueBytes.length];
        Encdec.enc_uint16le((short)((short)avId), (byte[])avPairBytes, (int)0);
        Encdec.enc_uint16le((short)((short)valueBytes.length), (byte[])avPairBytes, (int)2);
        System.arraycopy(valueBytes, 0, avPairBytes, 4, valueBytes.length);
        return avPairBytes;
    }

    protected byte[] getTargetInformation() throws UnsupportedEncodingException {
        byte[] computerName = this.getAVPairBytes(1, this._ntlmServiceAccount.getComputerName());
        byte[] domainName = this.getAVPairBytes(2, this._domain);
        byte[] targetInformation = ArrayUtil.append((byte[][])new byte[][]{computerName, domainName});
        byte[] eol = this.getAVPairBytes(0, "");
        targetInformation = ArrayUtil.append((byte[][])new byte[][]{targetInformation, eol});
        return targetInformation;
    }
}

