/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRGroup;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUserManager
implements UserManager {
    private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);
    public static final String PORTAL_LOGIN = "hl:portalLogin";
    protected static final String ACCOUNTING = "hl:accounting";
    protected static final String NT_ACCOUNTING = "nthl:accountingSet";
    private static final String SPECIAL_FOLDER_PATH = "/Workspace/MySpecialFolders/";
    Map<String, GCoreEndpoint.Profile.Endpoint> servlets = JCRRepository.servlets;

    public List<GCubeGroup> getGroups() throws InternalErrorException {
        ArrayList<GCubeGroup> groupsList = null;
        List list = null;
        GetMethod getMethod = null;
        try {
            groupsList = new ArrayList<GCubeGroup>();
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("ListGroupsServlet").uri().toString());
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Callin List Groups Servlet");
            XStream xstream = new XStream();
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
            for (String group : list) {
                groupsList.add(new JCRGroup(group));
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return groupsList;
    }

    public boolean isGroup(String groupId) throws InternalErrorException {
        Boolean found = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("IsGroupServlet").uri().toString() + "?groupName=" + groupId);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Is " + groupId + " a group? " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            found = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return found;
    }

    public GCubeGroup getGroup(String groupId) throws InternalErrorException {
        JCRGroup group = null;
        try {
            if (this.isGroup(groupId)) {
                group = new JCRGroup(groupId);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCubeGroup createGroup(String scope) throws InternalErrorException {
        this.logger.trace("Create a new group: " + scope);
        String newGroupName = Utils.getGroupByScope(scope);
        String displayName = this.getDisplayName(scope);
        GetMethod getMethod = null;
        JCRGroup group = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("CreateGroupServlet").uri().toString() + "?groupName=" + newGroupName + "&displayName=" + displayName);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Create Group " + newGroupName);
            this.logger.trace("Response " + getMethod.getResponseBodyAsString());
            try {
                group = new JCRGroup(newGroupName);
            }
            catch (Exception e) {
                this.logger.error("Error creating a new group ", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return group;
    }

    private String getDisplayName(String groupName) {
        String[] groupNameSplit = groupName.split("/");
        int size = groupNameSplit.length;
        String displayName = groupNameSplit[size - 1];
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAuthorizable(String groupName) throws InternalErrorException {
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("DeleteAuthorizableServlet").uri().toString() + "?groupName=" + groupName);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Delete user or group " + groupName);
            this.logger.trace("Response " + getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error removing User or group in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return true;
    }

    public List<String> getUsers() throws InternalErrorException {
        List users = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("ListUsersServlet").uri().toString());
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            users = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String name, String version) throws InternalErrorException {
        Boolean created = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            String pass = JCRUserManager.getSecurePassword(name);
            getMethod = new GetMethod(this.servlets.get("CreateUserServlet").uri().toString() + "?userName=" + name + "&pwd=" + pass);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            created = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            this.logger.trace("Create User " + name);
            this.logger.trace("Response " + created);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String name, String pass, String version) throws InternalErrorException {
        Boolean created = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("CreateUserServlet").uri().toString() + "?userName=" + name + "&pwd=" + pass);
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            created = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            this.logger.trace("Create User " + name);
            this.logger.trace("Response " + created);
        }
        catch (Exception e) {
            this.logger.error(name + " already exists", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return created;
    }

    public static String getSecurePassword(String message) throws InternalErrorException {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            digest = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return digest;
    }

    @Deprecated
    public boolean associateUserToGroup(String scope, String username, String userToAssociate) throws InternalErrorException, ItemNotFoundException {
        return this.associateUserToGroup(scope, username);
    }

    public boolean associateUserToGroup(String scope, String userToAssociate) throws InternalErrorException, ItemNotFoundException {
        block10: {
            String VREFolder;
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            UserManager gm = factory.getUserManager();
            String groupId = VREFolder = Utils.getGroupByScope(scope);
            String manager = this.getManager(groupId);
            try {
                JCRGroup group;
                if (gm.createUser(userToAssociate, null)) {
                    this.logger.trace(userToAssociate + " has been created");
                }
                if ((group = (JCRGroup)gm.getGroup(groupId)) != null) {
                    group.addMember(userToAssociate);
                }
                Workspace ws = null;
                try {
                    ws = factory.getHomeManager().getHome(manager).getWorkspace();
                }
                catch (WorkspaceFolderNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (HomeNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (UserNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                if (ws == null) break block10;
                JCRWorkspaceSharedFolder folder = (JCRWorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + groupId);
                this.logger.trace("VRE folder path: " + folder.getPath());
                ArrayList<String> user = new ArrayList<String>();
                user.add(userToAssociate);
                try {
                    folder.share(user);
                }
                catch (InsufficientPrivilegesException | WrongDestinationException e) {
                    throw new InternalErrorException(e);
                }
            }
            catch (InternalErrorException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return true;
    }

    @Deprecated
    public boolean removeUserFromGroup(String scope, String userToRemove, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        return this.removeUserFromGroup(scope, userToRemove);
    }

    public boolean removeUserFromGroup(String groupId, String userToRemove) throws InternalErrorException, ItemNotFoundException {
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        String manager = this.getManager(groupId);
        try {
            GCubeGroup group = gm.getGroup(groupId);
            if (group != null) {
                group.removeMember(userToRemove);
            }
            Workspace ws = null;
            try {
                ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(manager).getWorkspace();
            }
            catch (WorkspaceFolderNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (HomeNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (UserNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            if (ws != null) {
                JCRWorkspaceSharedFolder folder = (JCRWorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + groupId);
                this.logger.trace("VRE folder path: " + folder.getPath());
                folder.unShare(userToRemove);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean setAdministrator(String scope, String username, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        return this.setAdministrator(scope, username);
    }

    public boolean setAdministrator(String scope, String username) throws InternalErrorException, ItemNotFoundException {
        String VREFolder = Utils.getGroupByScope(scope);
        Workspace ws = null;
        String manager = this.getManager(VREFolder);
        try {
            ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(manager).getWorkspace();
            WorkspaceSharedFolder folder = (WorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + VREFolder);
            ArrayList<String> administator = new ArrayList<String>();
            administator.add(username);
            folder.setACL(administator, ACLType.ADMINISTRATOR);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean removeAdministrator(String scope, String username, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        return this.removeAdministrator(scope, username);
    }

    public boolean removeAdministrator(String scope, String username) throws InternalErrorException, ItemNotFoundException {
        String VREFolder = Utils.getGroupByScope(scope);
        Workspace ws = null;
        String manager = this.getManager(VREFolder);
        try {
            ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(manager).getWorkspace();
            WorkspaceSharedFolder folder = (WorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + VREFolder);
            ArrayList<String> administator = new ArrayList<String>();
            administator.add(username);
            folder.deleteACL(administator);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getManager(String scope) {
        String manager = scope + "-Manager";
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersionByUser(String user) throws InternalErrorException {
        String displayName;
        GetMethod getMethod = null;
        try {
            StringBuilder callUrl = new StringBuilder(this.servlets.get("GetVersionServlet").uri().toString()).append("?").append("user").append("=").append(user);
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(callUrl.toString());
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            displayName = (String)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setVersionByUser(String user, String version) throws InternalErrorException {
        boolean flag;
        GetMethod getMethod = null;
        try {
            StringBuilder callUrl = new StringBuilder(this.servlets.get("SetVersionServlet").uri().toString()).append("?").append("user").append("=").append(user).append("&").append("version").append("=").append(version);
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(callUrl.toString());
            TokenUtility.setHeader(getMethod);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return flag;
    }
}

