/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.gcubesearchlibrary.utils;

import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.BadRequestException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.InternalServerErrorException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.NotFoundException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.UnauthorizedException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class RequestHandler {
    public static String submitPostRequest(URL url, String urlParameters) throws UnauthorizedException, NotFoundException, IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        if (urlParameters != null) {
            writer.write(urlParameters);
        }
        writer.flush();
        writer.close();
        StringBuffer answer = new StringBuffer();
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            String line;
            InputStream in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            reader.close();
            return answer.toString();
        }
        if (responseCode == 401) {
            throw new UnauthorizedException("User is unauthorized");
        }
        if (responseCode == 404) {
            throw new NotFoundException("Not found");
        }
        return null;
    }

    public static String submitGetRequest(String targetURL, String sessionID) throws UnauthorizedException, NotFoundException, InternalServerErrorException, BadRequestException {
        String result = null;
        try {
            URLEncoder.encode(targetURL, "UTF-8");
            URL url = new URL(targetURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionID, "UTF-8"));
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer sb = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                result = sb.toString();
            } else {
                if (responseCode == 500) {
                    throw new InternalServerErrorException();
                }
                if (responseCode == 401) {
                    throw new UnauthorizedException("User is unauthorized");
                }
                if (responseCode == 404) {
                    throw new NotFoundException("Not found");
                }
                if (responseCode == 400) {
                    throw new BadRequestException("Bad Request");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String submitGetRequest(URL url, String sessionID) throws InternalServerErrorException, UnauthorizedException, NotFoundException, BadRequestException, IOException {
        int responseCode;
        String result = null;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (sessionID != null) {
            conn.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionID, "UTF-8"));
        }
        if ((responseCode = conn.getResponseCode()) == 200) {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            rd.close();
            result = sb.toString();
        } else {
            if (responseCode == 500) {
                throw new InternalServerErrorException();
            }
            if (responseCode == 401) {
                throw new UnauthorizedException("User is unauthorized");
            }
            if (responseCode == 404) {
                throw new NotFoundException("Not found");
            }
            if (responseCode == 400) {
                throw new BadRequestException("Bad Request");
            }
        }
        return result;
    }

    public static ByteArrayOutputStream submitGetRequestByteStream(URL url, String sessionID) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int bytesRead;
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionID, "UTF-8"));
            InputStream input = conn.getInputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }
}

