/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.net.InetAddress;
import java.security.SecureRandom;
import org.portletbridge.portlet.GUIDException;

public class GUIDGenerator {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '*', '-'};
    private SecureRandom seeder;
    private String midValue;
    private String midValueUnformated;

    public GUIDGenerator() throws GUIDException {
        try {
            String s;
            this.seeder = new SecureRandom();
            InetAddress inetaddress = InetAddress.getLocalHost();
            byte[] abyte0 = inetaddress.getAddress();
            this.midValue = s = this.urlFriendlyFormat(this.getInt(abyte0), 8);
            this.midValueUnformated = s;
        }
        catch (Exception exception) {
            throw new GUIDException("error - failure to instantiate GUIDGenerator" + exception);
        }
    }

    private String getVal(String s) {
        int i = (int)System.currentTimeMillis() & 0xFFFFFFFF;
        int j = this.seeder.nextInt();
        return this.urlFriendlyFormat(i, 8) + s + this.urlFriendlyFormat(j, 8);
    }

    public String getUnformatedUUID() {
        return this.getVal(this.midValueUnformated);
    }

    public String getUUID() {
        return this.getVal(this.midValue);
    }

    private int getInt(byte[] abyte0) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = abyte0[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private String urlFriendlyFormat(int i, int j) {
        StringBuffer result = new StringBuffer();
        do {
            result.append(table[i & 0x3F]);
        } while ((i >>>= 6) > 0);
        return result.toString();
    }
}

