/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

public class SerializableSessionAttributeListener
implements HttpSessionAttributeListener {
    private static Log _log = LogFactoryUtil.getLog(SerializableSessionAttributeListener.class);
    private static boolean _SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE;
    private Boolean _requiresSerializable;

    public static void initialize() {
        _SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE = GetterUtil.getBoolean(PropsUtil.get("session.verify.serializable.attribute"), true);
    }

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession session;
        if (!_SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            return;
        }
        String name = httpSessionBindingEvent.getName();
        Object value = httpSessionBindingEvent.getValue();
        if (value instanceof Serializable) {
            return;
        }
        Class<?> clazz = value.getClass();
        _log.error(String.valueOf(clazz.getName()) + " is not serializable and will prevent this session from " + "being replicated");
        if (this._requiresSerializable == null) {
            session = httpSessionBindingEvent.getSession();
            ServletContext servletContext = session.getServletContext();
            this._requiresSerializable = GetterUtil.getBoolean(servletContext.getInitParameter("session-attributes-requires-serializable"));
        }
        if (this._requiresSerializable.booleanValue()) {
            session = httpSessionBindingEvent.getSession();
            session.removeAttribute(name);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        this.attributeAdded(httpSessionBindingEvent);
    }
}

