/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class UserRoleAuthorizationInterceptor
extends HandlerInterceptorAdapter {
    private String[] authorizedRoles;

    public final void setAuthorizedRoles(String[] authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    public final boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws PortletException, IOException {
        if (this.authorizedRoles != null) {
            String[] stringArray = this.authorizedRoles;
            int n = this.authorizedRoles.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                if (request.isUserInRole(role)) {
                    return true;
                }
                ++n2;
            }
        }
        this.handleNotAuthorized(request, response, handler);
        return false;
    }

    protected void handleNotAuthorized(PortletRequest request, PortletResponse response, Object handler) throws PortletException, IOException {
        throw new PortletSecurityException("Request not authorized");
    }
}

