/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.TypeConversionHelper;

public class TimestampRDBMSMapping
extends AbstractDatastoreMapping {
    public TimestampRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(93, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(93);
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            if (value == null) {
                ps.setNull(param, this.getTypeInfo().getDataType());
            } else if (value instanceof Date) {
                if (cal != null) {
                    ps.setTimestamp(param, new Timestamp(((Date)value).getTime()), cal);
                } else {
                    ps.setTimestamp(param, new Timestamp(((Date)value).getTime()));
                }
            } else if (value instanceof Time) {
                if (cal != null) {
                    ps.setTimestamp(param, new Timestamp(((Time)value).getTime()), cal);
                } else {
                    ps.setTimestamp(param, new Timestamp(((Time)value).getTime()));
                }
            } else if (value instanceof java.sql.Date) {
                if (cal != null) {
                    ps.setTimestamp(param, new Timestamp(((java.sql.Date)value).getTime()), cal);
                } else {
                    ps.setTimestamp(param, new Timestamp(((java.sql.Date)value).getTime()));
                }
            } else if (value instanceof Calendar) {
                if (cal != null) {
                    ps.setTimestamp(param, new Timestamp(((Calendar)value).getTime().getTime()), cal);
                } else {
                    ps.setTimestamp(param, new Timestamp(((Calendar)value).getTime().getTime()));
                }
            } else if (cal != null) {
                ps.setTimestamp(param, (Timestamp)value, cal);
            } else {
                ps.setTimestamp(param, (Timestamp)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Timestamp", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    protected Timestamp getTimestamp(ResultSet rs, int param) {
        Timestamp value;
        Calendar cal = this.storeMgr.getCalendarForDateTimezone();
        try {
            value = cal != null ? rs.getTimestamp(param, cal) : rs.getTimestamp(param);
        }
        catch (SQLException e) {
            try {
                String s = rs.getString(param);
                value = rs.wasNull() ? null : (s == null ? null : TypeConversionHelper.stringToTimestamp((String)s, (Calendar)cal));
            }
            catch (SQLException nestedEx) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Timestamp", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)nestedEx);
            }
        }
        return value;
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Timestamp value = this.getTimestamp(rs, param);
        if (value == null) {
            return null;
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
            return new Date(this.getDatastoreAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
            return new java.sql.Date(this.getDatastoreAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
            return new Time(this.getDatastoreAdapter().getAdapterTime(value));
        }
        return new Timestamp(this.getDatastoreAdapter().getAdapterTime(value));
    }
}

