/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.model.impl.OrganizationBaseImpl;
import com.liferay.portal.service.AddressLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletPreferences;

public class OrganizationImpl
extends OrganizationBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(OrganizationImpl.class);

    public static String[] getChildrenTypes(String type) {
        return PropsUtil.getArray("organizations.children.types", new Filter(type));
    }

    public static String[] getParentTypes(String type) {
        String[] types = PropsUtil.getArray("organizations.types", new Filter(type));
        ArrayList<String> parentTypes = new ArrayList<String>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String curType = stringArray[n2];
            if (ArrayUtil.contains((Object[])OrganizationImpl.getChildrenTypes(curType), (Object)type)) {
                parentTypes.add(curType);
            }
            ++n2;
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    public static boolean isParentable(String type) {
        String[] childrenTypes = OrganizationImpl.getChildrenTypes(type);
        return childrenTypes.length > 0;
    }

    public static boolean isRootable(String type) {
        return GetterUtil.getBoolean((String)PropsUtil.get("organizations.rootable", new Filter(type)));
    }

    public Address getAddress() {
        Address address = null;
        try {
            List<Address> addresses = this.getAddresses();
            if (addresses.size() > 0) {
                address = addresses.get(0);
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        if (address == null) {
            address = new AddressImpl();
        }
        return address;
    }

    public List<Address> getAddresses() throws SystemException {
        return AddressLocalServiceUtil.getAddresses((long)this.getCompanyId(), (String)Organization.class.getName(), (long)this.getOrganizationId());
    }

    public List<Organization> getAncestors() throws PortalException, SystemException {
        ArrayList<Organization> ancestors = new ArrayList<Organization>();
        OrganizationImpl organization = this;
        while (!organization.isRoot()) {
            organization = organization.getParentOrganization();
            ancestors.add(organization);
        }
        return ancestors;
    }

    public String[] getChildrenTypes() {
        return OrganizationImpl.getChildrenTypes(this.getType());
    }

    public List<Organization> getDescendants() throws SystemException {
        UniqueList descendants = new UniqueList();
        for (Organization suborganization : this.getSuborganizations()) {
            descendants.add(suborganization);
            descendants.addAll(suborganization.getDescendants());
        }
        return descendants;
    }

    public Group getGroup() {
        if (this.getOrganizationId() > 0L) {
            try {
                return GroupLocalServiceUtil.getOrganizationGroup((long)this.getCompanyId(), (long)this.getOrganizationId());
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
        return new GroupImpl();
    }

    public long getGroupId() {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    public long getLogoId() {
        long logoId = 0L;
        try {
            Group group = this.getGroup();
            LayoutSet publicLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
            logoId = publicLayoutSet.getLogoId();
            if (logoId == 0L) {
                LayoutSet privateLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)true);
                logoId = privateLayoutSet.getLogoId();
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return logoId;
    }

    public Organization getParentOrganization() throws PortalException, SystemException {
        if (this.getParentOrganizationId() == 0L) {
            return null;
        }
        return OrganizationLocalServiceUtil.getOrganization((long)this.getParentOrganizationId());
    }

    public PortletPreferences getPreferences() throws SystemException {
        long ownerId = this.getOrganizationId();
        int ownerType = 6;
        return PortalPreferencesLocalServiceUtil.getPreferences((long)ownerId, (int)ownerType);
    }

    public int getPrivateLayoutsPageCount() {
        Group group;
        block3: {
            try {
                group = this.getGroup();
                if (group != null) break block3;
                return 0;
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
                return 0;
            }
        }
        return group.getPrivateLayoutsPageCount();
    }

    public int getPublicLayoutsPageCount() {
        Group group;
        block3: {
            try {
                group = this.getGroup();
                if (group != null) break block3;
                return 0;
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
                return 0;
            }
        }
        return group.getPublicLayoutsPageCount();
    }

    public Set<String> getReminderQueryQuestions(Locale locale) throws SystemException {
        return this.getReminderQueryQuestions(LanguageUtil.getLanguageId((Locale)locale));
    }

    public Set<String> getReminderQueryQuestions(String languageId) throws SystemException {
        PortletPreferences preferences = this.getPreferences();
        Object[] questions = StringUtil.splitLines((String)LocalizationUtil.getPreferencesValue((PortletPreferences)preferences, (String)"reminderQueries", (String)languageId, (boolean)false));
        return SetUtil.fromArray((Object[])questions);
    }

    public List<Organization> getSuborganizations() throws SystemException {
        return OrganizationLocalServiceUtil.getSuborganizations((long)this.getCompanyId(), (long)this.getOrganizationId());
    }

    public int getSuborganizationsSize() throws SystemException {
        return OrganizationLocalServiceUtil.getSuborganizationsCount((long)this.getCompanyId(), (long)this.getOrganizationId());
    }

    public int getTypeOrder() {
        String[] types = PropsValues.ORGANIZATIONS_TYPES;
        int i2 = 0;
        while (i2 < types.length) {
            String type = types[i2];
            if (type.equals(this.getType())) {
                return i2 + 1;
            }
            ++i2;
        }
        return 0;
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean hasSuborganizations() throws SystemException {
        return this.getSuborganizationsSize() > 0;
    }

    public boolean isParentable() {
        return OrganizationImpl.isParentable(this.getType());
    }

    public boolean isRoot() {
        return this.getParentOrganizationId() == 0L;
    }
}

