/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.trash.DuplicateEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.wiki.asset.WikiNodeTrashRenderer;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class WikiNodeTrashHandler
extends BaseTrashHandler {
    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
        WikiNode duplicateNode;
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)trashEntry.getClassPK());
        String originalTitle = trashEntry.getTypeSettingsProperty("title");
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateNode = WikiNodeLocalServiceUtil.fetchNode((long)node.getGroupId(), (String)originalTitle)) != null) {
            DuplicateEntryException dee = new DuplicateEntryException();
            dee.setDuplicateEntryId(duplicateNode.getNodeId());
            dee.setOldName(duplicateNode.getName());
            dee.setTrashEntryId(trashEntry.getEntryId());
            throw dee;
        }
    }

    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        WikiNodeLocalServiceUtil.deleteNode((long)classPK);
    }

    public String getClassName() {
        return WikiNode.class.getName();
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, false);
        portletURL.setParameter("nodeId", String.valueOf(node.getNodeId()));
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.translate("wiki");
    }

    public String getTrashContainedModelName() {
        return "wiki-pages";
    }

    public int getTrashContainedModelsCount(long classPK) throws SystemException {
        return WikiPageLocalServiceUtil.getPagesCount((long)classPK, (boolean)true, (int)8);
    }

    public List<TrashRenderer> getTrashContainedModelTrashRenderers(long classPK, int start, int end) throws PortalException, SystemException {
        ArrayList<TrashRenderer> trashRenderers = new ArrayList<TrashRenderer>();
        List pages = WikiPageLocalServiceUtil.getPages((long)classPK, (boolean)true, (int)8, (int)start, (int)end);
        for (WikiPage page : pages) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)WikiPage.class.getName());
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(page.getResourcePrimKey());
            trashRenderers.add(trashRenderer);
        }
        return trashRenderers;
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        return node.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        return new WikiNodeTrashRenderer(node);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        return node.isInTrash();
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        WikiNodeLocalServiceUtil.restoreNodeFromTrash((long)userId, (WikiNode)node);
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        node.setName(name);
        WikiNodeLocalServiceUtil.updateWikiNode((WikiNode)node);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean isContainerModel) throws PortalException, SystemException {
        String portletId = "36";
        WikiNode node = WikiNodeLocalServiceUtil.getNode((long)classPK);
        long plid = PortalUtil.getPlidFromPortletId((long)node.getGroupId(), (String)"36");
        if (plid == 0L) {
            portletId = "154";
            plid = PortalUtil.getControlPanelPlid((PortletRequest)portletRequest);
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        if (!isContainerModel) {
            if (portletId.equals("36")) {
                portletURL.setParameter("struts_action", "/wiki/view_all_pages");
            } else {
                portletURL.setParameter("struts_action", "/wiki_admin/view_all_pages");
            }
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        return WikiNodePermission.contains(permissionChecker, classPK, actionId);
    }
}

