/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.lang.RandomStringUtils;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.generators.AbstractTreeTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuralTemplate
extends AbstractTreeTemplate {
    private static Logger logger = LoggerFactory.getLogger(StructuralTemplate.class);
    private static final int defaultWidth = 5;
    private static final int defaultDepth = 2;
    private static final int defaultValueSize = 3000;
    Integer width = 5;
    Integer depth = 2;
    Integer value = 3000;
    int attributes = 0;
    private boolean generateIDs = false;
    private Map<Integer, List<String>> labels;
    private String sourceId;

    protected StructuralTemplate() {
    }

    @Override
    public Tree generate() {
        if (this.labels == null) {
            this.generateLabels();
        }
        InnerNode node = this.inner(0);
        Tree tree = new Tree(node.id(), node.attributes(), node.edges().toArray(new Edge[0]));
        if (this.sourceId != null) {
            tree.setSourceId(this.sourceId);
        }
        return tree;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tree template");
        b.append("\n======================");
        b.append("\nwidth=" + this.width);
        b.append("\ndepth=" + this.depth);
        b.append("\ntotal payload=" + Math.round(Math.pow(this.width.intValue(), this.depth.intValue()) * (double)this.value.intValue() / 1024.0) + "kb");
        b.append("\n");
        return b.toString();
    }

    private void generateLabels() {
        int lblcount = 0;
        this.labels = new HashMap<Integer, List<String>>();
        for (int i = 0; i < this.depth; ++i) {
            ArrayList<String> lbls = new ArrayList<String>();
            this.labels.put(i, lbls);
            for (int j = 0; j < this.width; ++j) {
                String lbl = null;
                while ((lbl = RandomStringUtils.randomAlphabetic((int)this.random(5, 10))).contains("{") || lbl.contains("}")) {
                }
                lbls.add(lbl);
            }
            lblcount += lbls.size();
        }
        logger.trace("using " + lblcount + " different labels");
    }

    private InnerNode inner(int depth) {
        Edge[] edges = this.edges(depth);
        InnerNode node = new InnerNode(this.newId(), edges);
        Map<QName, String> attributes = this.attributes(depth);
        for (Map.Entry<QName, String> entry : attributes.entrySet()) {
            node.setAttribute(entry.getKey(), entry.getValue());
        }
        return node;
    }

    private String newId() {
        return this.generateIDs ? UUID.randomUUID().toString() : null;
    }

    private Leaf leaf(int depth) {
        Leaf l = new Leaf(this.newId(), RandomStringUtils.randomAlphabetic((int)this.value));
        return l;
    }

    private Node node(int depth) {
        if (depth == this.depth - 1) {
            return this.leaf(depth);
        }
        return this.inner(depth + 1);
    }

    private String label(int depth) {
        List<String> lbls = this.labels.get(depth);
        return lbls.get(this.random(0, lbls.size() - 1));
    }

    private Edge edge(int depth) {
        String label = this.label(depth);
        Edge e = new Edge(label, this.node(depth));
        return e;
    }

    private Edge[] edges(int depth) {
        Edge[] edges = new Edge[this.width.intValue()];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = this.edge(depth);
        }
        return edges;
    }

    private Map<QName, String> attributes(int depth) {
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        for (int i = 0; i < this.attributes; ++i) {
            attrs.put(new QName(this.label(depth)), this.label(depth));
        }
        return attrs;
    }

    private int random(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static class STBuilder {
        private StructuralTemplate template = new StructuralTemplate();

        public STBuilder inSource(String id) {
            this.template.sourceId = id;
            return this;
        }

        public STBuilder wide(int w) {
            this.template.width = w;
            return this;
        }

        public STBuilder deep(int depth) {
            this.template.depth = depth;
            return this;
        }

        public StructuralTemplate totalling(int size) {
            double bytes = size * 1024;
            double w = this.template.width == null ? 5.0 : this.template.width.doubleValue();
            double d = this.template.depth == null ? 2.0 : this.template.depth.doubleValue();
            int val = (int)Math.rint(bytes / Math.pow(w, d));
            if (this.template.value != null) {
                logger.warn("leaf value is reset to " + val);
            }
            this.template.value = val;
            logger.trace("inferring value as " + this.template.value);
            return this.build();
        }

        public STBuilder withAttributes(int max) {
            this.template.attributes = max;
            return this;
        }

        public STBuilder withValuesOf(int max) {
            this.template.value = max * 1024;
            return this;
        }

        public STBuilder withIds() {
            this.template.generateIDs = true;
            return this;
        }

        public StructuralTemplate build() {
            return this.template;
        }
    }
}

