/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Roi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;

public class Overlay {
    private Vector list = new Vector();
    private boolean label;
    private boolean drawNames;
    private boolean drawBackgrounds;
    private Color labelColor;
    private Font labelFont;

    public Overlay() {
    }

    public Overlay(Roi roi) {
        this.list.add(roi);
    }

    public void add(Roi roi) {
        this.list.add(roi);
    }

    public void addElement(Roi roi) {
        this.list.add(roi);
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public void remove(Roi roi) {
        this.list.remove(roi);
    }

    public void clear() {
        this.list.clear();
    }

    public Roi get(int index) {
        return (Roi)this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public Roi[] toArray() {
        Roi[] array = new Roi[this.list.size()];
        return this.list.toArray(array);
    }

    public void setStrokeColor(Color color) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setStrokeColor(color);
        }
    }

    public void setFillColor(Color color) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setFillColor(color);
        }
    }

    public void translate(int dx, int dy) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            Rectangle r = rois[i].getBounds();
            rois[i].setLocation(r.x + dx, r.y + dy);
        }
    }

    public Overlay duplicate() {
        Roi[] rois = this.toArray();
        Overlay overlay2 = new Overlay();
        for (int i = 0; i < rois.length; ++i) {
            overlay2.add((Roi)rois[i].clone());
        }
        overlay2.drawLabels(this.label);
        overlay2.drawNames(this.drawNames);
        overlay2.drawBackgrounds(this.drawBackgrounds);
        overlay2.setLabelColor(this.labelColor);
        overlay2.setLabelFont(this.labelFont);
        return overlay2;
    }

    public String toString() {
        return this.list.toString();
    }

    public void drawLabels(boolean b) {
        this.label = b;
    }

    public boolean getDrawLabels() {
        return this.label;
    }

    public void drawNames(boolean b) {
        this.drawNames = b;
    }

    public boolean getDrawNames() {
        return this.drawNames;
    }

    public void drawBackgrounds(boolean b) {
        this.drawBackgrounds = b;
    }

    public boolean getDrawBackgrounds() {
        return this.drawBackgrounds;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    void setVector(Vector v) {
        this.list = v;
    }

    Vector getVector() {
        return this.list;
    }
}

