/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.MergeSortedIterators;

class ValueMap {
    static final SortedMap<Revision, String> EMPTY = Collections.unmodifiableSortedMap(new TreeMap(StableRevisionComparator.REVERSE));

    ValueMap() {
    }

    @Nonnull
    static Map<Revision, String> create(final @Nonnull NodeDocument doc, final @Nonnull String property) {
        final SortedMap<Revision, String> map = doc.getLocalMap(property);
        if (doc.getPreviousRanges().isEmpty()) {
            return map;
        }
        final AbstractSet<Map.Entry<Revision, String>> entrySet = new AbstractSet<Map.Entry<Revision, String>>(){

            @Override
            @Nonnull
            public Iterator<Map.Entry<Revision, String>> iterator() {
                final Comparator c = map.comparator();
                final Iterator docs = map.isEmpty() ? doc.getPreviousDocs(property, null).iterator() : Iterators.concat((Iterator)Iterators.singletonIterator((Object)doc), doc.getPreviousDocs(property, null).iterator());
                return new MergeSortedIterators<Map.Entry<Revision, String>>((Comparator)new Comparator<Map.Entry<Revision, String>>(){

                    @Override
                    public int compare(Map.Entry<Revision, String> o1, Map.Entry<Revision, String> o2) {
                        return c.compare(o1.getKey(), o2.getKey());
                    }
                }){

                    @Override
                    public Iterator<Map.Entry<Revision, String>> nextIterator() {
                        NodeDocument d;
                        NodeDocument nodeDocument = d = docs.hasNext() ? (NodeDocument)docs.next() : null;
                        if (d == null) {
                            return null;
                        }
                        Map<Revision, String> values = Objects.equal((Object)d.getId(), (Object)doc.getId()) ? d.getLocalMap(property) : d.getValueMap(property);
                        return values.entrySet().iterator();
                    }

                    @Override
                    public String description() {
                        return "Revisioned values for property " + doc.getId() + "/" + property + ":";
                    }
                };
            }

            @Override
            public int size() {
                int size = map.size();
                for (NodeDocument prev : doc.getPreviousDocs(property, null)) {
                    size += prev.getValueMap(property).size();
                }
                return size;
            }
        };
        return new AbstractMap<Revision, String>(){
            private final Map<Revision, String> map;
            {
                this.map = doc.getLocalMap(property);
            }

            @Override
            @Nonnull
            public Set<Map.Entry<Revision, String>> entrySet() {
                return entrySet;
            }

            @Override
            public String get(Object key) {
                String value = this.map.get(key);
                if (value != null) {
                    return value;
                }
                Revision r = (Revision)key;
                for (NodeDocument prev : doc.getPreviousDocs(property, r)) {
                    value = prev.getValueMap(property).get(key);
                    if (value == null) continue;
                    return value;
                }
                return null;
            }

            @Override
            public boolean containsKey(Object key) {
                return this.get(key) != null;
            }
        };
    }
}

