/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public abstract class AbstractTree
implements Tree {
    private static final String[] INTERNAL_NODE_NAMES = new String[]{":index", ":references", ":weakreferences", ":conflict"};
    protected String name;
    protected NodeBuilder nodeBuilder;

    protected AbstractTree(@Nonnull String name, @Nonnull NodeBuilder nodeBuilder) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.nodeBuilder = (NodeBuilder)Preconditions.checkNotNull((Object)nodeBuilder);
    }

    @Nonnull
    public NodeState getNodeState() {
        return this.nodeBuilder.getNodeState();
    }

    @Nonnull
    protected abstract AbstractTree createChild(@Nonnull String var1) throws IllegalArgumentException;

    protected boolean isNew() {
        return this.nodeBuilder.isNew();
    }

    protected boolean isModified() {
        return this.nodeBuilder.isModified();
    }

    protected boolean hasOrderableChildren() {
        return this.nodeBuilder.hasProperty(":childOrder");
    }

    @Nonnull
    protected Iterable<String> getChildNames() {
        PropertyState order = this.nodeBuilder.getProperty(":childOrder");
        if (order != null && order.getType() == Type.NAMES) {
            LinkedHashSet names = Sets.newLinkedHashSet(this.nodeBuilder.getChildNodeNames());
            ArrayList ordered = Lists.newArrayListWithCapacity((int)names.size());
            for (String name : order.getValue(Type.NAMES)) {
                if (!names.remove(name)) continue;
                ordered.add(name);
            }
            ordered.addAll(names);
            return ordered;
        }
        return this.nodeBuilder.getChildNodeNames();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath()).append(": ");
        sb.append('{');
        for (PropertyState propertyState : this.getProperties()) {
            sb.append(' ').append(propertyState).append(',');
        }
        for (String string : this.getChildNames()) {
            sb.append(' ').append(string).append(" = { ... },");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRoot() {
        return this.name.isEmpty();
    }

    @Override
    public String getPath() {
        if (this.isRoot()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        this.buildPath(sb);
        return sb.toString();
    }

    protected void buildPath(StringBuilder sb) {
        if (!this.isRoot()) {
            this.getParent().buildPath(sb);
            sb.append('/').append(this.name);
        }
    }

    @Override
    public Tree.Status getStatus() {
        if (this.nodeBuilder.isNew()) {
            return Tree.Status.NEW;
        }
        if (this.nodeBuilder.isModified()) {
            return Tree.Status.MODIFIED;
        }
        return Tree.Status.UNCHANGED;
    }

    @Override
    public boolean exists() {
        return this.nodeBuilder.exists() && !NodeStateUtils.isHidden(this.name);
    }

    @Override
    public abstract AbstractTree getParent();

    @Override
    public PropertyState getProperty(String name) {
        return !NodeStateUtils.isHidden((String)Preconditions.checkNotNull((Object)name)) ? this.nodeBuilder.getProperty(name) : null;
    }

    @Override
    public boolean hasProperty(String name) {
        return !NodeStateUtils.isHidden((String)Preconditions.checkNotNull((Object)name)) && this.nodeBuilder.hasProperty(name);
    }

    @Override
    public long getPropertyCount() {
        return Iterables.size(this.getProperties());
    }

    @Override
    public Tree.Status getPropertyStatus(@Nonnull String name) {
        if (!this.hasProperty(name)) {
            return null;
        }
        if (this.nodeBuilder.isNew(name)) {
            return Tree.Status.NEW;
        }
        if (this.nodeBuilder.isReplaced(name)) {
            return Tree.Status.MODIFIED;
        }
        return Tree.Status.UNCHANGED;
    }

    @Override
    public Iterable<? extends PropertyState> getProperties() {
        return Iterables.filter(this.nodeBuilder.getProperties(), (Predicate)new Predicate<PropertyState>(){

            public boolean apply(PropertyState propertyState) {
                return !NodeStateUtils.isHidden(propertyState.getName());
            }
        });
    }

    @Override
    public boolean hasChild(String name) {
        return this.nodeBuilder.hasChildNode(name) && !NodeStateUtils.isHidden(name);
    }

    @Override
    public long getChildrenCount(long max) {
        max = max + (long)INTERNAL_NODE_NAMES.length < 0L ? Long.MAX_VALUE : (max += (long)INTERNAL_NODE_NAMES.length);
        long count = this.nodeBuilder.getChildNodeCount(max);
        if (count > 0L) {
            for (String name : INTERNAL_NODE_NAMES) {
                if (!this.nodeBuilder.hasChildNode(name)) continue;
                --count;
            }
        }
        return count;
    }

    @Override
    public Iterable<Tree> getChildren() {
        Iterable children = Iterables.transform(this.getChildNames(), (Function)new Function<String, Tree>(){

            public Tree apply(String name) {
                AbstractTree child = AbstractTree.this.createChild(name);
                return child.exists() ? child : null;
            }
        });
        return Iterables.filter((Iterable)children, (Predicate)Predicates.notNull());
    }
}

