/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.StringBasedBlob;
import org.apache.jackrabbit.util.ISO8601;

public final class Conversions {
    private static final TimeZone UTC = TimeZone.getTimeZone("GMT+00:00");

    private Conversions() {
    }

    public static Converter convert(final String value) {
        return new Converter(){

            @Override
            public String toString() {
                return value;
            }
        };
    }

    public static Converter convert(final Blob value) {
        return new Converter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String toString() {
                String string;
                InputStream in = value.getNewStream();
                try {
                    string = new String(ByteStreams.toByteArray((InputStream)in), Charsets.UTF_8);
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                in.close();
                return string;
            }

            @Override
            public Blob toBinary() {
                return value;
            }
        };
    }

    public static Converter convert(final long value) {
        return new Converter(){

            @Override
            public String toString() {
                return String.valueOf(value);
            }

            @Override
            public long toLong() {
                return value;
            }

            @Override
            public double toDouble() {
                return value;
            }

            @Override
            public Calendar toCalendar() {
                Calendar date = Calendar.getInstance(UTC);
                date.setTimeInMillis(value);
                return date;
            }

            @Override
            public BigDecimal toDecimal() {
                return BigDecimal.valueOf(value);
            }
        };
    }

    public static Converter convert(final double value) {
        return new Converter(){

            @Override
            public String toString() {
                return String.valueOf(value);
            }

            @Override
            public long toLong() {
                return (long)value;
            }

            @Override
            public double toDouble() {
                return value;
            }

            @Override
            public Calendar toCalendar() {
                Calendar date = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
                date.setTimeInMillis(this.toLong());
                return date;
            }

            @Override
            public BigDecimal toDecimal() {
                return BigDecimal.valueOf(value);
            }
        };
    }

    public static Converter convert(final String value, Type<?> type) {
        if (type == Type.DECIMAL) {
            return Conversions.convert(Conversions.convert(value).toDecimal());
        }
        if (type == Type.DOUBLE) {
            return Conversions.convert(Conversions.convert(value).toDouble());
        }
        if (type == Type.LONG) {
            return Conversions.convert(Conversions.convert(value).toLong());
        }
        if (type != Type.DATE) {
            return Conversions.convert(value);
        }
        return new Converter(){

            @Override
            public String toString() {
                return value;
            }

            @Override
            public Calendar toCalendar() {
                return ISO8601.parse((String)this.toString());
            }

            @Override
            public long toLong() {
                return this.toCalendar().getTimeInMillis();
            }

            @Override
            public double toDouble() {
                return this.toLong();
            }

            @Override
            public BigDecimal toDecimal() {
                return new BigDecimal(this.toLong());
            }
        };
    }

    public static Converter convert(final boolean value) {
        return new Converter(){

            @Override
            public String toString() {
                return Boolean.toString(value);
            }

            @Override
            public boolean toBoolean() {
                return value;
            }
        };
    }

    public static Converter convert(final BigDecimal value) {
        return new Converter(){

            @Override
            public String toString() {
                return value.toString();
            }

            @Override
            public long toLong() {
                return value.longValue();
            }

            @Override
            public double toDouble() {
                return value.doubleValue();
            }

            @Override
            public Calendar toCalendar() {
                Calendar date = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
                date.setTimeInMillis(this.toLong());
                return date;
            }

            @Override
            public BigDecimal toDecimal() {
                return value;
            }
        };
    }

    public static abstract class Converter {
        public abstract String toString();

        public Blob toBinary() {
            return new StringBasedBlob(this.toString());
        }

        public long toLong() {
            return Long.parseLong(this.toString());
        }

        public double toDouble() {
            return Double.parseDouble(this.toString());
        }

        public Calendar toCalendar() {
            Calendar date = ISO8601.parse((String)this.toString());
            if (date == null) {
                throw new IllegalArgumentException("Not a date string: " + this.toString());
            }
            return date;
        }

        public String toDate() {
            return ISO8601.format((Calendar)this.toCalendar());
        }

        public boolean toBoolean() {
            return Boolean.parseBoolean(this.toString());
        }

        public BigDecimal toDecimal() {
            return new BigDecimal(this.toString());
        }
    }
}

