/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class MembershipWriter {
    private int membershipSizeThreshold = 100;

    public int getMembershipSizeThreshold() {
        return this.membershipSizeThreshold;
    }

    public void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.membershipSizeThreshold = membershipSizeThreshold;
    }

    boolean addMember(Tree groupTree, String memberContentId) throws RepositoryException {
        PropertyBuilder<String> propertyBuilder;
        Tree membersList = groupTree.getChild("rep:membersList");
        Iterator trees = Iterators.concat((Iterator)Iterators.singletonIterator((Object)groupTree), membersList.getChildren().iterator());
        int bestCount = this.membershipSizeThreshold;
        PropertyState bestProperty = null;
        Tree bestTree = null;
        while (trees.hasNext()) {
            Tree t = (Tree)trees.next();
            PropertyState refs = t.getProperty("rep:members");
            if (refs == null) continue;
            int numRefs = 0;
            for (String ref : refs.getValue(Type.WEAKREFERENCES)) {
                if (ref.equals(memberContentId)) {
                    return false;
                }
                ++numRefs;
            }
            if (numRefs >= bestCount) continue;
            bestCount = numRefs;
            bestProperty = refs;
            bestTree = t;
        }
        if (bestProperty == null) {
            if (!groupTree.hasProperty("rep:members")) {
                bestTree = groupTree;
            } else {
                if (!membersList.exists()) {
                    membersList = groupTree.addChild("rep:membersList");
                    membersList.setProperty("jcr:primaryType", "rep:MemberReferencesList", Type.NAME);
                    bestTree = membersList.addChild("0");
                } else {
                    int i = 0;
                    String name = String.valueOf(i);
                    while (membersList.hasChild(name)) {
                        name = String.valueOf(++i);
                    }
                    bestTree = membersList.addChild(name);
                }
                bestTree.setProperty("jcr:primaryType", "rep:MemberReferences", Type.NAME);
            }
            propertyBuilder = PropertyBuilder.array(Type.WEAKREFERENCE, "rep:members");
        } else {
            propertyBuilder = PropertyBuilder.copy(Type.WEAKREFERENCE, bestProperty);
        }
        propertyBuilder.addValue(memberContentId);
        bestTree.setProperty(propertyBuilder.getPropertyState());
        return true;
    }

    boolean removeMember(Tree groupTree, String memberContentId) {
        Tree membersList = groupTree.getChild("rep:membersList");
        Iterator trees = Iterators.concat((Iterator)Iterators.singletonIterator((Object)groupTree), membersList.getChildren().iterator());
        while (trees.hasNext()) {
            PropertyBuilder<String> prop;
            Tree t = (Tree)trees.next();
            PropertyState refs = t.getProperty("rep:members");
            if (refs == null || !(prop = PropertyBuilder.copy(Type.WEAKREFERENCE, refs)).hasValue(memberContentId)) continue;
            prop.removeValue(memberContentId);
            if (prop.isEmpty()) {
                if (t == groupTree) {
                    t.removeProperty("rep:members");
                } else {
                    t.remove();
                }
            } else {
                t.setProperty(prop.getPropertyState());
            }
            return true;
        }
        return false;
    }

    public void setMembers(NodeBuilder group, Set<String> members) {
        group.removeProperty("rep:members");
        if (group.hasChildNode("rep:members")) {
            group.getChildNode("rep:members").remove();
        }
        PropertyBuilder<String> prop = null;
        NodeBuilder refList = null;
        NodeBuilder node = group;
        int count = 0;
        int numNodes = 0;
        for (String ref : members) {
            if (prop == null) {
                prop = PropertyBuilder.array(Type.WEAKREFERENCE, "rep:members");
            }
            prop.addValue(ref);
            if (++count <= this.membershipSizeThreshold) continue;
            node.setProperty(prop.getPropertyState());
            prop = null;
            if (refList == null) {
                refList = group.child("rep:membersList");
                refList.setProperty("jcr:primaryType", "rep:MemberReferencesList", Type.NAME);
            }
            node = refList.child(String.valueOf(numNodes++));
            node.setProperty("jcr:primaryType", "rep:MemberReferences", Type.NAME);
        }
        if (prop != null) {
            node.setProperty(prop.getPropertyState());
        }
    }
}

