/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.lar;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.DefaultConfigurationPortletDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.assetpublisher.util.AssetPublisher;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.portlet.PortletPreferences;

public class AssetPublisherPortletDataHandler
extends DefaultConfigurationPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(AssetPublisherPortletDataHandler.class);

    public AssetPublisherPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setPublishToLiveByDefault(true);
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return this.updateExportPortletPreferences(portletDataContext, portletId, portletPreferences);
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return this.updateImportPortletPreferences(portletDataContext, portletId, portletPreferences);
    }

    protected void updateExportClassNameIds(PortletPreferences portletPreferences, String key) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        String[] stringArray = oldValues;
        int n = oldValues.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String oldValue = stringArray[n2];
                if (key.equals("anyAssetType") && (oldValue.equals("false") || oldValue.equals("true"))) {
                    newValues[i2++] = oldValue;
                } else {
                    try {
                        long classNameId = GetterUtil.getLong((String)oldValue);
                        String className = PortalUtil.getClassName((long)classNameId);
                        newValues[i2++] = className;
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block6;
                        _log.warn((Object)("Unable to get class name ID for class name " + oldValue));
                    }
                }
            }
            ++n2;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateExportDDMStructures(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key) throws Exception {
        String oldValue = portletPreferences.getValue(key, null);
        if (Validator.isNull((String)oldValue) || !oldValue.startsWith("ddm/")) {
            return;
        }
        String[] oldValueParts = StringUtil.split((String)oldValue, (String)"/");
        long ddmStructureId = Long.valueOf(oldValueParts[1]);
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchDDMStructure((long)ddmStructureId);
        if (ddmStructure == null) {
            portletPreferences.reset(key);
            return;
        }
        String newValue = oldValue.replace(String.valueOf(ddmStructureId), ddmStructure.getUuid());
        portletPreferences.setValue(key, newValue);
    }

    protected PortletPreferences updateExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        String anyAssetTypeClassName = "";
        long anyAssetType = GetterUtil.getLong((String)portletPreferences.getValue("anyAssetType", null));
        if (anyAssetType > 0L) {
            anyAssetTypeClassName = PortalUtil.getClassName((long)anyAssetType);
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        Enumeration enu = portletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String index;
            String name = (String)enu.nextElement();
            String value = GetterUtil.getString((String)portletPreferences.getValue(name, null));
            if (name.equals("anyAssetType") || name.equals("classNameIds")) {
                this.updateExportClassNameIds(portletPreferences, name);
                continue;
            }
            if (name.equals("anyClassTypeDLFileEntryAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(DLFileEntry.class.getName()) || name.equals("classTypeIdsDLFileEntryAssetRendererFactory")) {
                ExportImportHelperUtil.updateExportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (Portlet)portlet, (PortletPreferences)portletPreferences, (String)name, (String)DLFileEntryType.class.getName(), (Element)portletDataContext.getExportDataRootElement());
                continue;
            }
            if (name.equals("anyClassTypeJournalArticleAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(JournalArticle.class.getName()) || name.equals("classTypeIdsJournalArticleAssetRendererFactory")) {
                ExportImportHelperUtil.updateExportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (Portlet)portlet, (PortletPreferences)portletPreferences, (String)name, (String)DDMStructure.class.getName(), (Element)portletDataContext.getExportDataRootElement());
                continue;
            }
            if (name.equals("assetVocabularyId")) {
                ExportImportHelperUtil.updateExportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (Portlet)portlet, (PortletPreferences)portletPreferences, (String)name, (String)AssetVocabulary.class.getName(), (Element)portletDataContext.getExportDataRootElement());
                continue;
            }
            if (name.startsWith("orderByColumn")) {
                this.updateExportDDMStructures(portletDataContext, portletPreferences, name);
                continue;
            }
            if (name.startsWith("queryName") && StringUtil.equalsIgnoreCase((String)value, (String)"assetCategories")) {
                index = name.substring(9);
                ExportImportHelperUtil.updateExportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (Portlet)portlet, (PortletPreferences)portletPreferences, (String)("queryValues" + index), (String)AssetCategory.class.getName(), (Element)portletDataContext.getExportDataRootElement());
                continue;
            }
            if (name.startsWith("queryName") && StringUtil.equalsIgnoreCase((String)value, (String)"assetTags")) {
                index = name.substring(9);
                Object[] assetTagNames = portletPreferences.getValues("queryValues" + index, null);
                if (ArrayUtil.isEmpty((Object[])assetTagNames)) continue;
                portletDataContext.addAssetTags(AssetPublisher.class.getName(), 0L, (String[])assetTagNames);
                continue;
            }
            if (!name.equals("scopeIds")) continue;
            this.updateExportScopeIds(portletDataContext, portletPreferences, name, portletDataContext.getPlid());
        }
        return portletPreferences;
    }

    protected void updateExportScopeIds(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, long plid) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        String companyGroupScopeId = "Group_" + portletDataContext.getCompanyGroupId();
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String oldValue = oldValues[i2];
            if (oldValue.startsWith("Group_")) {
                newValues[i2] = StringUtil.replace((String)oldValue, (String)companyGroupScopeId, (String)"[$COMPANY_GROUP_SCOPE_ID$]");
            } else if (oldValue.startsWith("Layout_")) {
                String scopeIdSuffix = oldValue.substring("Layout_".length());
                long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdSuffix);
                Layout scopeIdLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)scopeIdLayoutId);
                newValues[i2] = "LayoutUuid_" + scopeIdLayout.getUuid();
            } else {
                newValues[i2] = oldValue;
            }
            ++i2;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportClassNameIds(PortletPreferences portletPreferences, String key) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        String[] stringArray = oldValues;
        int n = oldValues.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String oldValue = stringArray[n2];
                if (key.equals("anyAssetType") && (oldValue.equals("false") || oldValue.equals("true"))) {
                    newValues[i2++] = oldValue;
                } else {
                    try {
                        long classNameId = PortalUtil.getClassNameId((String)oldValue);
                        newValues[i2++] = String.valueOf(classNameId);
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block6;
                        _log.warn((Object)("Unable to find class name ID for class name " + oldValue));
                    }
                }
            }
            ++n2;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportDDMStructures(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key) throws Exception {
        String oldValue = portletPreferences.getValue(key, null);
        if (Validator.isNull((String)oldValue) || !oldValue.startsWith("ddm/")) {
            return;
        }
        String[] oldValueParts = StringUtil.split((String)oldValue, (String)"/");
        String ddmStructureUuid = oldValueParts[1];
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)ddmStructureUuid, (long)portletDataContext.getScopeGroupId());
        if (ddmStructure == null) {
            ddmStructure = DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)ddmStructureUuid, (long)portletDataContext.getCompanyGroupId());
        }
        if (ddmStructure == null) {
            return;
        }
        long ddmStructureId = ddmStructure.getStructureId();
        String newValue = oldValue.replace(String.valueOf(ddmStructureUuid), String.valueOf(ddmStructureId));
        portletPreferences.setValue(key, newValue);
    }

    protected PortletPreferences updateImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)portletDataContext.getCompanyId());
        Group companyGroup = company.getGroup();
        String anyAssetTypeClassName = portletPreferences.getValue("anyAssetType", "");
        Enumeration enu = portletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = GetterUtil.getString((String)portletPreferences.getValue(name, null));
            if (name.equals("anyAssetType") || name.equals("classNameIds")) {
                this.updateImportClassNameIds(portletPreferences, name);
                continue;
            }
            if (name.equals("anyClassTypeDLFileEntryAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(DLFileEntry.class.getName()) || name.equals("classTypeIdsDLFileEntryAssetRendererFactory")) {
                ExportImportHelperUtil.updateImportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (PortletPreferences)portletPreferences, (String)name, DLFileEntryType.class, (long)companyGroup.getGroupId());
                continue;
            }
            if (name.equals("anyClassTypeJournalArticleAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(JournalArticle.class.getName()) || name.equals("classTypeIdsJournalArticleAssetRendererFactory")) {
                ExportImportHelperUtil.updateImportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (PortletPreferences)portletPreferences, (String)name, DDMStructure.class, (long)companyGroup.getGroupId());
                continue;
            }
            if (name.equals("assetVocabularyId")) {
                ExportImportHelperUtil.updateImportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (PortletPreferences)portletPreferences, (String)name, AssetVocabulary.class, (long)companyGroup.getGroupId());
                continue;
            }
            if (name.startsWith("orderByColumn")) {
                this.updateImportDDMStructures(portletDataContext, portletPreferences, name);
                continue;
            }
            if (name.startsWith("queryName") && StringUtil.equalsIgnoreCase((String)value, (String)"assetCategories")) {
                String index = name.substring(9, name.length());
                ExportImportHelperUtil.updateImportPortletPreferencesClassPKs((PortletDataContext)portletDataContext, (PortletPreferences)portletPreferences, (String)("queryValues" + index), AssetCategory.class, (long)companyGroup.getGroupId());
                continue;
            }
            if (!name.equals("scopeIds")) continue;
            this.updateImportScopeIds(portletPreferences, name, companyGroup.getGroupId(), portletDataContext.getPlid());
        }
        return portletPreferences;
    }

    protected void updateImportScopeIds(PortletPreferences portletPreferences, String key, long companyGroupId, long plid) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        String companyGroupScopeId = "Group_" + companyGroupId;
        ArrayList<String> newValues = new ArrayList<String>(oldValues.length);
        String[] stringArray = oldValues;
        int n = oldValues.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                String oldValue = stringArray[n2];
                String newValue = StringUtil.replace((String)oldValue, (String)"[$COMPANY_GROUP_SCOPE_ID$]", (String)companyGroupScopeId);
                try {
                    if (AssetPublisherUtil.isScopeIdSelectable((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (String)newValue, (long)companyGroupId, (Layout)layout)) {
                        newValues.add(newValue);
                    }
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Ignoring scope " + newValue + " because the " + "referenced group was not found"));
                    }
                }
                catch (PrincipalException principalException) {
                    if (!_log.isInfoEnabled()) break block7;
                    _log.info((Object)("Ignoring scope " + newValue + " because the " + "referenced parent group no longer allows " + "sharing content with child sites"));
                }
            }
            ++n2;
        }
        portletPreferences.setValues(key, newValues.toArray(new String[newValues.size()]));
    }
}

