/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.DuplicateTableNameException;
import com.liferay.portlet.expando.TableNameException;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.base.ExpandoTableLocalServiceBaseImpl;
import java.util.List;

public class ExpandoTableLocalServiceImpl
extends ExpandoTableLocalServiceBaseImpl {
    public ExpandoTable addDefaultTable(long companyId, long classNameId) throws PortalException, SystemException {
        return this.addTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable addDefaultTable(long companyId, String className) throws PortalException, SystemException {
        return this.addTable(companyId, className, "CUSTOM_FIELDS");
    }

    public ExpandoTable addTable(long companyId, long classNameId, String name) throws PortalException, SystemException {
        this.validate(companyId, 0L, classNameId, name);
        long tableId = this.counterLocalService.increment();
        ExpandoTable table = this.expandoTablePersistence.create(tableId);
        table.setCompanyId(companyId);
        table.setClassNameId(classNameId);
        table.setName(name);
        this.expandoTablePersistence.update((BaseModel)table);
        return table;
    }

    public ExpandoTable addTable(long classNameId, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.addTable(companyId, classNameId, name);
    }

    public ExpandoTable addTable(long companyId, String className, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.addTable(companyId, classNameId, name);
    }

    public ExpandoTable addTable(String className, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.addTable(companyId, className, name);
    }

    public void deleteTable(ExpandoTable table) throws SystemException {
        this.expandoTablePersistence.remove((BaseModel)table);
        this.runSQL("delete from ExpandoColumn where tableId = " + table.getTableId());
        this.expandoColumnPersistence.clearCache();
        this.runSQL("delete from ExpandoRow where tableId = " + table.getTableId());
        this.expandoRowPersistence.clearCache();
        this.runSQL("delete from ExpandoValue where tableId = " + table.getTableId());
        this.expandoValuePersistence.clearCache();
    }

    public void deleteTable(long tableId) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        this.deleteTable(table);
    }

    public void deleteTable(long companyId, long classNameId, String name) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
        this.deleteTable(table);
    }

    public void deleteTable(long companyId, String className, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteTable(companyId, classNameId, name);
    }

    public void deleteTables(long companyId, long classNameId) throws SystemException {
        List tables = this.expandoTablePersistence.findByC_C(companyId, classNameId);
        for (ExpandoTable table : tables) {
            this.deleteTable(table);
        }
    }

    public void deleteTables(long companyId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteTables(companyId, classNameId);
    }

    public ExpandoTable fetchDefaultTable(long companyId, long classNameId) throws SystemException {
        return this.fetchTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable fetchDefaultTable(long companyId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.fetchTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable fetchTable(long companyId, long classNameId, String name) throws SystemException {
        return this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
    }

    public ExpandoTable getDefaultTable(long companyId, long classNameId) throws PortalException, SystemException {
        return this.getTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable getDefaultTable(long companyId, String className) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable getTable(long tableId) throws PortalException, SystemException {
        return this.expandoTablePersistence.findByPrimaryKey(tableId);
    }

    public ExpandoTable getTable(long companyId, long classNameId, String name) throws PortalException, SystemException {
        return this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
    }

    public ExpandoTable getTable(long classNameId, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.getTable(companyId, classNameId, name);
    }

    public ExpandoTable getTable(long companyId, String className, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTable(companyId, classNameId, name);
    }

    public ExpandoTable getTable(String className, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.getTable(companyId, className, name);
    }

    public List<ExpandoTable> getTables(long companyId, long classNameId) throws SystemException {
        return this.expandoTablePersistence.findByC_C(companyId, classNameId);
    }

    public List<ExpandoTable> getTables(long companyId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTables(companyId, classNameId);
    }

    public ExpandoTable updateTable(long tableId, String name) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        if (table.getName().equals("CUSTOM_FIELDS")) {
            throw new TableNameException("Cannot rename CUSTOM_FIELDS");
        }
        this.validate(table.getCompanyId(), tableId, table.getClassNameId(), name);
        table.setName(name);
        return (ExpandoTable)this.expandoTablePersistence.update((BaseModel)table);
    }

    protected void validate(long companyId, long tableId, long classNameId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new TableNameException();
        }
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
        if (table != null && table.getTableId() != tableId) {
            throw new DuplicateTableNameException("{tableId=" + tableId + "}");
        }
    }
}

