/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok;

import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.javac.CommentInfo;
import lombok.javac.Javac;
import lombok.javac.handlers.JavacHandlerUtil;

public class DocCommentIntegrator {
    private static final Pattern CONTENT_STRIPPER = Pattern.compile("^(?:\\s*\\*)?[ \\t]*(.*?)$", 8);

    public java.util.List<CommentInfo> integrate(java.util.List<CommentInfo> comments, JCTree.JCCompilationUnit unit) {
        ArrayList<CommentInfo> out = new ArrayList<CommentInfo>();
        CommentInfo lastExcisedComment = null;
        JCTree lastNode = null;
        for (CommentInfo cmt : comments) {
            if (!cmt.isJavadoc()) {
                out.add(cmt);
                continue;
            }
            JCTree node = this.findJavadocableNodeOnOrAfter(unit, cmt.endPos);
            if (node == null) {
                out.add(cmt);
                continue;
            }
            if (node == lastNode) {
                out.add(lastExcisedComment);
            }
            if (!this.attach(unit, node, cmt)) {
                out.add(cmt);
                continue;
            }
            lastNode = node;
            lastExcisedComment = cmt;
        }
        return out;
    }

    private boolean attach(JCTree.JCCompilationUnit top, JCTree node, CommentInfo cmt) {
        Object map_;
        String docCommentContent = cmt.content;
        if (docCommentContent.startsWith("/**")) {
            docCommentContent = docCommentContent.substring(3);
        }
        if (docCommentContent.endsWith("*/")) {
            docCommentContent = docCommentContent.substring(0, docCommentContent.length() - 2);
        }
        docCommentContent = CONTENT_STRIPPER.matcher(docCommentContent).replaceAll("$1");
        docCommentContent = docCommentContent.trim();
        if (Javac.getDocComments(top) == null) {
            Javac.initDocComments(top);
        }
        if ((map_ = Javac.getDocComments(top)) instanceof Map) {
            ((Map)map_).put(node, docCommentContent);
            return true;
        }
        if (Javac.instanceOfDocCommentTable(map_)) {
            CommentAttacher_8.attach(node, docCommentContent, map_);
            return true;
        }
        return false;
    }

    private JCTree findJavadocableNodeOnOrAfter(JCTree.JCCompilationUnit unit, int endPos) {
        if (unit.pid != null && endPos <= unit.pid.pos) {
            return null;
        }
        Iterator<JCTree> it = unit.defs.iterator();
        while (it.hasNext()) {
            JCTree node = it.next();
            if (node.pos < endPos) {
                if (!(node instanceof JCTree.JCClassDecl)) continue;
                List<JCTree> defs = ((JCTree.JCClassDecl)node).defs;
                if (!defs.isEmpty()) {
                    while (!defs.tail.isEmpty()) {
                        defs = defs.tail;
                    }
                }
                if (defs.head == null || ((JCTree)defs.head).pos < endPos) continue;
                it = ((JCTree.JCClassDecl)node).defs.iterator();
                continue;
            }
            if (node instanceof JCTree.JCMethodDecl || node instanceof JCTree.JCClassDecl || node instanceof JCTree.JCVariableDecl) {
                return node;
            }
            return null;
        }
        return null;
    }

    private static class CommentAttacher_8 {
        private CommentAttacher_8() {
        }

        static void attach(final JCTree node, String docCommentContent, Object map_) {
            final String docCommentContent_ = docCommentContent;
            ((DocCommentTable)map_).putComment(node, new Tokens.Comment(){

                @Override
                public String getText() {
                    return docCommentContent_;
                }

                @Override
                public int getSourcePos(int index) {
                    return -1;
                }

                @Override
                public Tokens.Comment.CommentStyle getStyle() {
                    return Tokens.Comment.CommentStyle.JAVADOC;
                }

                @Override
                public boolean isDeprecated() {
                    return JavacHandlerUtil.nodeHasDeprecatedFlag(node);
                }
            });
        }
    }
}

