/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;

class Record {
    private final SegmentId segmentId;
    private final int offset;

    static boolean fastEquals(Object a, Object b) {
        return a instanceof Record && Record.fastEquals((Record)a, b);
    }

    static boolean fastEquals(Record a, Object b) {
        return b instanceof Record && Record.fastEquals(a, (Record)b);
    }

    static boolean fastEquals(Record a, Record b) {
        return a.segmentId == b.segmentId && a.offset == b.offset;
    }

    protected Record(@Nonnull RecordId id) {
        this(id.getSegmentId(), id.getOffset());
    }

    protected Record(@Nonnull SegmentId segmentId, int offset) {
        this.segmentId = segmentId;
        this.offset = offset;
    }

    protected Segment getSegment() {
        return this.segmentId.getSegment();
    }

    public RecordId getRecordId() {
        return new RecordId(this.segmentId, this.offset);
    }

    protected final int getOffset() {
        return this.offset;
    }

    protected final int getOffset(int position) {
        return this.getOffset() + position;
    }

    protected final int getOffset(int bytes, int ids) {
        return this.getOffset(bytes + ids * 3);
    }

    public boolean equals(Object that) {
        return Record.fastEquals(this, that);
    }

    public int hashCode() {
        return this.segmentId.hashCode() ^ this.offset;
    }

    public String toString() {
        return this.getRecordId().toString();
    }
}

