/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentIdTable;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentTracker {
    private static final Logger log = LoggerFactory.getLogger(SegmentTracker.class);
    private static final long MSB_MASK = -61441L;
    private static final long VERSION = 16384L;
    private static final long LSB_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long DATA = -6917529027641081856L;
    private static final long BULK = -5764607523034234880L;
    private static final int MB = 0x100000;
    private static final int DEFAULT_MEMORY_CACHE_SIZE = 256;
    private final SecureRandom random = new SecureRandom();
    private final SegmentStore store;
    private final SegmentWriter writer;
    private final long cacheSize;
    private final SegmentIdTable[] tables = new SegmentIdTable[32];
    private final LinkedList<Segment> segments = Lists.newLinkedList();
    private long currentSize = 0L;

    public SegmentTracker(SegmentStore store, int cacheSizeMB) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = new SegmentIdTable(this);
        }
        this.store = store;
        this.writer = new SegmentWriter(store, this);
        this.cacheSize = cacheSizeMB * 0x100000;
    }

    public SegmentTracker(SegmentStore store) {
        this(store, 256);
    }

    public SegmentWriter getWriter() {
        return this.writer;
    }

    public SegmentStore getStore() {
        return this.store;
    }

    Segment getSegment(SegmentId id) {
        Segment segment = this.store.readSegment(id);
        this.setSegment(id, segment);
        return segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSegment(SegmentId id, Segment segment) {
        id.setSegment(segment);
        SegmentTracker segmentTracker = this;
        synchronized (segmentTracker) {
            long size = segment.getCacheSize();
            this.segments.addFirst(segment);
            this.currentSize += size;
            log.debug("Added segment {} to tracker cache ({} bytes)", (Object)id, (Object)size);
            while (this.currentSize > this.cacheSize && this.segments.size() > 1) {
                Segment last = this.segments.removeLast();
                SegmentId lastId = last.getSegmentId();
                if (last.accessed()) {
                    this.segments.addFirst(last);
                    log.debug("Segment {} was recently used, keeping in cache", (Object)lastId);
                    continue;
                }
                long lastSize = last.getCacheSize();
                lastId.setSegment(null);
                this.currentSize -= lastSize;
                log.debug("Removed segment {} from tracker cache ({} bytes)", (Object)lastId, (Object)lastSize);
            }
        }
    }

    public synchronized Set<SegmentId> getReferencedSegmentIds() {
        HashSet ids = Sets.newHashSet();
        for (SegmentIdTable table : this.tables) {
            table.collectReferencedIds(ids);
        }
        return ids;
    }

    public void collectBlobReferences(ReferenceCollector collector) {
        Set processed = Sets.newIdentityHashSet();
        ArrayDeque queue = Queues.newArrayDeque(this.getReferencedSegmentIds());
        this.writer.flush();
        while (!queue.isEmpty()) {
            SegmentId id = (SegmentId)queue.remove();
            if (!id.isDataSegmentId() || !processed.add(id)) continue;
            Segment segment = id.getSegment();
            segment.collectBlobReferences(collector);
            for (SegmentId refid : segment.getReferencedIds()) {
                if (!refid.isDataSegmentId() || processed.contains(refid)) continue;
                queue.add(refid);
            }
        }
    }

    public SegmentId getSegmentId(long msb, long lsb) {
        int index = (int)msb & this.tables.length - 1;
        return this.tables[index].getSegmentId(msb, lsb);
    }

    SegmentId newDataSegmentId() {
        return this.newSegmentId(-6917529027641081856L);
    }

    SegmentId newBulkSegmentId() {
        return this.newSegmentId(-5764607523034234880L);
    }

    private SegmentId newSegmentId(long type) {
        long msb = this.random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb = this.random.nextLong() & 0xFFFFFFFFFFFFFFFL | type;
        return this.getSegmentId(msb, lsb);
    }
}

