/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeWorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

public abstract class CompositeConfiguration<T extends SecurityConfiguration>
implements SecurityConfiguration {
    private final List<T> configurations = new CopyOnWriteArrayList<T>();
    private final String name;
    private final SecurityProvider securityProvider;
    private T defaultConfig;

    public CompositeConfiguration(@Nonnull String name, @Nonnull SecurityProvider securityProvider) {
        this.name = name;
        this.securityProvider = securityProvider;
    }

    public void setDefaultConfig(@Nonnull T defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public void addConfiguration(@Nonnull T configuration) {
        this.configurations.add(configuration);
    }

    public void removeConfiguration(@Nonnull T configuration) {
        this.configurations.remove(configuration);
    }

    protected List<T> getConfigurations() {
        if (this.configurations.isEmpty() && this.defaultConfig != null) {
            return ImmutableList.of(this.defaultConfig);
        }
        return ImmutableList.copyOf(this.configurations);
    }

    protected SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public ConfigurationParameters getParameters() {
        List<T> configs = this.getConfigurations();
        ConfigurationParameters[] params = new ConfigurationParameters[configs.size()];
        for (int i = 0; i < configs.size(); ++i) {
            params[i] = ((SecurityConfiguration)configs.get(i)).getParameters();
        }
        return ConfigurationParameters.of(params);
    }

    @Override
    @Nonnull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new CompositeWorkspaceInitializer(Lists.transform(this.getConfigurations(), (Function)new Function<T, WorkspaceInitializer>(){

            public WorkspaceInitializer apply(T securityConfiguration) {
                return securityConfiguration.getWorkspaceInitializer();
            }
        }));
    }

    @Override
    @Nonnull
    public RepositoryInitializer getRepositoryInitializer() {
        return new CompositeInitializer(Lists.transform(this.getConfigurations(), (Function)new Function<T, RepositoryInitializer>(){

            public RepositoryInitializer apply(T securityConfiguration) {
                return securityConfiguration.getRepositoryInitializer();
            }
        }));
    }

    @Override
    @Nonnull
    public List<? extends CommitHook> getCommitHooks(final String workspaceName) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Lists.transform(this.getConfigurations(), (Function)new Function<T, List<? extends CommitHook>>(){

            public List<? extends CommitHook> apply(T securityConfiguration) {
                return securityConfiguration.getCommitHooks(workspaceName);
            }
        })));
    }

    @Override
    @Nonnull
    public List<? extends ValidatorProvider> getValidators(final String workspaceName, final Set<Principal> principals, final MoveTracker moveTracker) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Lists.transform(this.getConfigurations(), (Function)new Function<T, List<? extends ValidatorProvider>>(){

            public List<? extends ValidatorProvider> apply(T securityConfiguration) {
                return securityConfiguration.getValidators(workspaceName, principals, moveTracker);
            }
        })));
    }

    @Override
    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Lists.transform(this.getConfigurations(), (Function)new Function<T, List<? extends ProtectedItemImporter>>(){

            public List<? extends ProtectedItemImporter> apply(T securityConfiguration) {
                return securityConfiguration.getProtectedItemImporters();
            }
        })));
    }

    @Override
    public Context getContext() {
        final List<T> configs = this.getConfigurations();
        return new Context(){

            @Override
            public boolean definesProperty(@Nonnull Tree parent, @Nonnull PropertyState property) {
                for (SecurityConfiguration sc : configs) {
                    if (!sc.getContext().definesProperty(parent, property)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean definesContextRoot(@Nonnull Tree tree) {
                for (SecurityConfiguration sc : configs) {
                    if (!sc.getContext().definesContextRoot(tree)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean definesTree(@Nonnull Tree tree) {
                for (SecurityConfiguration sc : configs) {
                    if (!sc.getContext().definesTree(tree)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean definesLocation(@Nonnull TreeLocation location) {
                for (SecurityConfiguration sc : configs) {
                    if (!sc.getContext().definesLocation(location)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

