/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;

public class PDFontDescriptorDictionary
extends PDFontDescriptor
implements COSObjectable {
    private COSDictionary dic;
    private float xHeight = Float.NEGATIVE_INFINITY;
    private float capHeight = Float.NEGATIVE_INFINITY;
    private int flags = -1;

    public PDFontDescriptorDictionary() {
        this.dic = new COSDictionary();
        this.dic.setItem(COSName.TYPE, (COSBase)COSName.FONT_DESC);
    }

    public PDFontDescriptorDictionary(COSDictionary desc) {
        this.dic = desc;
    }

    public COSDictionary getCOSDictionary() {
        return this.dic;
    }

    public COSBase getCOSObject() {
        return this.dic;
    }

    public String getFontName() {
        String retval = null;
        COSName name = (COSName)this.dic.getDictionaryObject(COSName.FONT_NAME);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setFontName(String fontName) {
        COSName name = null;
        if (fontName != null) {
            name = COSName.getPDFName(fontName);
        }
        this.dic.setItem(COSName.FONT_NAME, (COSBase)name);
    }

    public String getFontFamily() {
        String retval = null;
        COSString name = (COSString)this.dic.getDictionaryObject(COSName.FONT_FAMILY);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public void setFontFamily(String fontFamily) {
        COSString name = null;
        if (fontFamily != null) {
            name = new COSString(fontFamily);
        }
        this.dic.setItem(COSName.FONT_FAMILY, (COSBase)name);
    }

    public float getFontWeight() {
        return this.dic.getFloat(COSName.FONT_WEIGHT, 0.0f);
    }

    public void setFontWeight(float fontWeight) {
        this.dic.setFloat(COSName.FONT_WEIGHT, fontWeight);
    }

    public String getFontStretch() {
        String retval = null;
        COSName name = (COSName)this.dic.getDictionaryObject(COSName.FONT_STRETCH);
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setFontStretch(String fontStretch) {
        COSName name = null;
        if (fontStretch != null) {
            name = COSName.getPDFName(fontStretch);
        }
        this.dic.setItem(COSName.FONT_STRETCH, (COSBase)name);
    }

    public int getFlags() {
        if (this.flags == -1) {
            this.flags = this.dic.getInt(COSName.FLAGS, 0);
        }
        return this.flags;
    }

    public void setFlags(int flags) {
        this.dic.setInt(COSName.FLAGS, flags);
        this.flags = flags;
    }

    public PDRectangle getFontBoundingBox() {
        COSArray rect = (COSArray)this.dic.getDictionaryObject(COSName.FONT_BBOX);
        PDRectangle retval = null;
        if (rect != null) {
            retval = new PDRectangle(rect);
        }
        return retval;
    }

    public void setFontBoundingBox(PDRectangle rect) {
        COSArray array = null;
        if (rect != null) {
            array = rect.getCOSArray();
        }
        this.dic.setItem(COSName.FONT_BBOX, (COSBase)array);
    }

    public float getItalicAngle() {
        return this.dic.getFloat(COSName.ITALIC_ANGLE, 0.0f);
    }

    public void setItalicAngle(float angle) {
        this.dic.setFloat(COSName.ITALIC_ANGLE, angle);
    }

    public float getAscent() {
        return this.dic.getFloat(COSName.ASCENT, 0.0f);
    }

    public void setAscent(float ascent) {
        this.dic.setFloat(COSName.ASCENT, ascent);
    }

    public float getDescent() {
        return this.dic.getFloat(COSName.DESCENT, 0.0f);
    }

    public void setDescent(float descent) {
        this.dic.setFloat(COSName.DESCENT, descent);
    }

    public float getLeading() {
        return this.dic.getFloat(COSName.LEADING, 0.0f);
    }

    public void setLeading(float leading) {
        this.dic.setFloat(COSName.LEADING, leading);
    }

    public float getCapHeight() {
        if (this.capHeight == Float.NEGATIVE_INFINITY) {
            this.capHeight = Math.abs(this.dic.getFloat(COSName.CAP_HEIGHT, 0.0f));
        }
        return this.capHeight;
    }

    public void setCapHeight(float capHeight) {
        this.dic.setFloat(COSName.CAP_HEIGHT, capHeight);
        this.capHeight = capHeight;
    }

    public float getXHeight() {
        if (this.xHeight == Float.NEGATIVE_INFINITY) {
            this.xHeight = Math.abs(this.dic.getFloat(COSName.XHEIGHT, 0.0f));
        }
        return this.xHeight;
    }

    public void setXHeight(float xHeight) {
        this.dic.setFloat(COSName.XHEIGHT, xHeight);
        this.xHeight = xHeight;
    }

    public float getStemV() {
        return this.dic.getFloat(COSName.STEM_V, 0.0f);
    }

    public void setStemV(float stemV) {
        this.dic.setFloat(COSName.STEM_V, stemV);
    }

    public float getStemH() {
        return this.dic.getFloat(COSName.STEM_H, 0.0f);
    }

    public void setStemH(float stemH) {
        this.dic.setFloat(COSName.STEM_H, stemH);
    }

    public float getAverageWidth() {
        return this.dic.getFloat(COSName.AVG_WIDTH, 0.0f);
    }

    public void setAverageWidth(float averageWidth) {
        this.dic.setFloat(COSName.AVG_WIDTH, averageWidth);
    }

    public float getMaxWidth() {
        return this.dic.getFloat(COSName.MAX_WIDTH, 0.0f);
    }

    public void setMaxWidth(float maxWidth) {
        this.dic.setFloat(COSName.MAX_WIDTH, maxWidth);
    }

    public float getMissingWidth() {
        return this.dic.getFloat(COSName.MISSING_WIDTH, 0.0f);
    }

    public void setMissingWidth(float missingWidth) {
        this.dic.setFloat(COSName.MISSING_WIDTH, missingWidth);
    }

    public String getCharSet() {
        String retval = null;
        COSString name = (COSString)this.dic.getDictionaryObject(COSName.CHAR_SET);
        if (name != null) {
            retval = name.getString();
        }
        return retval;
    }

    public void setCharacterSet(String charSet) {
        COSString name = null;
        if (charSet != null) {
            name = new COSString(charSet);
        }
        this.dic.setItem(COSName.CHAR_SET, (COSBase)name);
    }

    public PDStream getFontFile() {
        PDStream retval = null;
        COSStream stream = (COSStream)this.dic.getDictionaryObject(COSName.FONT_FILE);
        if (stream != null) {
            retval = new PDStream(stream);
        }
        return retval;
    }

    public void setFontFile(PDStream type1Stream) {
        this.dic.setItem(COSName.FONT_FILE, (COSObjectable)type1Stream);
    }

    public PDStream getFontFile2() {
        PDStream retval = null;
        COSStream stream = (COSStream)this.dic.getDictionaryObject(COSName.FONT_FILE2);
        if (stream != null) {
            retval = new PDStream(stream);
        }
        return retval;
    }

    public void setFontFile2(PDStream ttfStream) {
        this.dic.setItem(COSName.FONT_FILE2, (COSObjectable)ttfStream);
    }

    public PDStream getFontFile3() {
        PDStream retval = null;
        COSStream stream = (COSStream)this.dic.getDictionaryObject(COSName.FONT_FILE3);
        if (stream != null) {
            retval = new PDStream(stream);
        }
        return retval;
    }

    public void setFontFile3(PDStream stream) {
        this.dic.setItem(COSName.FONT_FILE3, (COSObjectable)stream);
    }
}

