/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;

public class MapSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{Map.class, HashMap.class, TreeMap.class, LinkedHashMap.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && Map.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!(java_class.equals("java.util.Map") || java_class.equals("java.util.AbstractMap") || java_class.equals("java.util.LinkedHashMap") || java_class.equals("java.util.TreeMap") || java_class.equals("java.util.HashMap"))) {
            throw new UnmarshallException("not a Map");
        }
        JSONObject jsonmap = jso.getJSONObject("map");
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m = this.ser.tryUnmarshall(state, null, jsonmap.get(key)).max(m);
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        AbstractMap abmap = null;
        if (java_class.equals("java.util.Map") || java_class.equals("java.util.AbstractMap") || java_class.equals("java.util.HashMap")) {
            abmap = new HashMap();
        } else if (java_class.equals("java.util.TreeMap")) {
            abmap = new TreeMap();
        } else if (java_class.equals("java.util.LinkedHashMap")) {
            abmap = new LinkedHashMap();
        } else {
            throw new UnmarshallException("not a Map");
        }
        JSONObject jsonmap = jso.getJSONObject("map");
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                abmap.put(key, this.ser.unmarshall(state, null, jsonmap.get(key)));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage());
        }
        return abmap;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        Map map = (Map)o;
        JSONObject obj = new JSONObject();
        JSONObject mapdata = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            obj.put("javaClass", (Object)o.getClass().getName());
        }
        obj.put("map", (Object)mapdata);
        Object key = null;
        Object val = null;
        try {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry ent = i.next();
                key = ent.getKey();
                val = ent.getValue();
                mapdata.put(key.toString(), this.ser.marshall(state, val));
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("map key " + key + " " + e.getMessage());
        }
        return obj;
    }
}

