/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class MissingLastRevSeeker {
    protected final String ROOT_PATH = "/";
    private final DocumentStore store;

    public MissingLastRevSeeker(DocumentStore store) {
        this.store = store;
    }

    public Iterable<ClusterNodeInfoDocument> getAllClusters() {
        return this.store.query(Collection.CLUSTER_NODES, "0", "a", Integer.MAX_VALUE);
    }

    public ClusterNodeInfoDocument getClusterNodeInfo(int clusterId) {
        return this.store.find(Collection.CLUSTER_NODES, String.valueOf(clusterId));
    }

    public Iterable<NodeDocument> getCandidates(final long startTime, final long endTime) {
        List<NodeDocument> nodes = this.store.query(Collection.NODES, "0000000", ";", Integer.MAX_VALUE);
        return Iterables.filter(nodes, (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument input) {
                Long modified = (Long)input.get("_modified");
                return modified != null && modified >= Commit.getModifiedInSecs(startTime) && modified <= Commit.getModifiedInSecs(endTime);
            }
        });
    }

    public boolean acquireRecoveryLock(int clusterId) {
        UpdateOp update = new UpdateOp(Integer.toString(clusterId), true);
        update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
        this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
        return true;
    }

    public void releaseRecoveryLock(int clusterId) {
        UpdateOp update = new UpdateOp(Integer.toString(clusterId), true);
        update.set("recoveryLock", null);
        this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
    }

    public NodeDocument getRoot() {
        return this.store.find(Collection.NODES, Utils.getIdFromPath("/"));
    }

    public boolean isRecoveryNeeded(long currentTime) {
        for (ClusterNodeInfoDocument nodeInfo : this.getAllClusters()) {
            if (!nodeInfo.isActive() || currentTime <= nodeInfo.getLeaseEndTime() || nodeInfo.isBeingRecovered()) continue;
            return true;
        }
        return false;
    }
}

