/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexLookup;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class PropertyIndex
implements QueryIndex {
    private static final int MAX_STRING_LENGTH = 100;
    private static final String EMPTY_TOKEN = ":";

    PropertyIndex() {
    }

    static Set<String> encode(PropertyValue value) {
        if (value == null) {
            return null;
        }
        HashSet<String> values = new HashSet<String>();
        for (String v : value.getValue(Type.STRINGS)) {
            try {
                if (v.length() > 100) {
                    v = v.substring(0, 100);
                }
                v = v.isEmpty() ? EMPTY_TOKEN : URLEncoder.encode(v, Charsets.UTF_8.name());
                values.add(v);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 is unsupported", e);
            }
        }
        return values;
    }

    @Override
    public String getIndexName() {
        return "property";
    }

    PropertyIndexLookup getLookup(NodeState root) {
        return new PropertyIndexLookup(root);
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        PropertyIndexLookup lookup = this.getLookup(root);
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            String propertyName = PathUtils.getName((String)pr.propertyName);
            if (!lookup.isIndexed(propertyName, "/", filter)) continue;
            if (pr.firstIncluding && pr.lastIncluding && pr.first != null && pr.first.equals(pr.last)) {
                return lookup.getCost(filter, propertyName, pr.first);
            }
            if (pr.list != null) {
                double cost = 0.0;
                for (PropertyValue p : pr.list) {
                    cost += lookup.getCost(filter, propertyName, p);
                }
                return cost;
            }
            return lookup.getCost(filter, propertyName, null);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        Iterable paths = null;
        PropertyIndexLookup lookup = this.getLookup(root);
        int depth = 1;
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            String propertyName = PathUtils.getName((String)pr.propertyName);
            depth = PathUtils.getDepth((String)pr.propertyName);
            if (!lookup.isIndexed(propertyName, "/", filter)) continue;
            if (pr.firstIncluding && pr.lastIncluding && pr.first != null && pr.first.equals(pr.last)) {
                paths = lookup.query(filter, propertyName, pr.first);
                break;
            }
            if (pr.list != null) {
                for (PropertyValue pv : pr.list) {
                    Iterable<String> p = lookup.query(filter, propertyName, pv);
                    if (paths == null) {
                        paths = p;
                        continue;
                    }
                    paths = Iterables.concat(paths, p);
                }
                break;
            }
            paths = lookup.query(filter, propertyName, null);
            break;
        }
        if (paths == null) {
            throw new IllegalStateException("Property index is used even when no index is available for filter " + filter);
        }
        Cursor c = Cursors.newPathCursor(paths, filter.getQueryEngineSettings());
        if (depth > 1) {
            c = Cursors.newAncestorCursor(c, depth - 1, filter.getQueryEngineSettings());
        }
        return c;
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        StringBuilder buff = new StringBuilder("property");
        StringBuilder notIndexed = new StringBuilder();
        PropertyIndexLookup lookup = this.getLookup(root);
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            String propertyName = PathUtils.getName((String)pr.propertyName);
            if (lookup.isIndexed(propertyName, "/", filter)) {
                if (pr.firstIncluding && pr.lastIncluding && pr.first != null && pr.first.equals(pr.last)) {
                    buff.append(' ').append(propertyName).append('=').append(pr.first);
                    continue;
                }
                buff.append(' ').append(propertyName);
                continue;
            }
            if (pr.list != null) {
                buff.append(' ').append(propertyName).append(" IN(");
                int i = 0;
                for (PropertyValue pv : pr.list) {
                    if (i++ > 0) {
                        buff.append(", ");
                    }
                    buff.append(pv);
                }
                buff.append(')');
                continue;
            }
            notIndexed.append(' ').append(propertyName);
            if (pr.toString().isEmpty()) continue;
            notIndexed.append(':').append(pr);
        }
        if (notIndexed.length() > 0) {
            buff.append(" (").append(notIndexed.toString().trim()).append(")");
        }
        return buff.toString();
    }
}

