/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.compressedstream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressedObjectStream {
    public static void writeObject(Serializable object, ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream bfos = new BufferedOutputStream(bos);
        GZIPOutputStream gz = new GZIPOutputStream(bfos);
        ObjectOutputStream oos = new ObjectOutputStream(gz);
        oos.writeObject(object);
        gz.finish();
        oos.flush();
        byte[] compressed = bos.toByteArray();
        out.writeObject(compressed);
        bos.close();
        bfos.close();
        gz.close();
        oos.close();
    }

    public static Serializable readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] compressed = (byte[])in.readObject();
        Serializable obj = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
        BufferedInputStream bfis = new BufferedInputStream(bis);
        GZIPInputStream gz = new GZIPInputStream(bfis);
        ObjectInputStream ois = new ObjectInputStream(gz);
        obj = (Serializable)ois.readObject();
        bis.close();
        bfis.close();
        gz.close();
        ois.close();
        return obj;
    }
}

