/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import lombok.AccessLevel;
import lombok.ConfigurationKeys;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.HandlerUtil;
import lombok.experimental.Wither;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleWither
extends JavacAnnotationHandler<Wither> {
    public void generateWitherForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelWither) {
        boolean notAClass;
        if (checkForTypeLevelWither && JavacHandlerUtil.hasAnnotation(Wither.class, typeNode)) {
            return;
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x6200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Wither is only supported on a class or a field.");
            return;
        }
        for (JavacNode field : typeNode.down()) {
            if (field.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
            if (fieldDecl.name.toString().startsWith("$") || (fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x10L) != 0L && fieldDecl.init != null) continue;
            this.generateWitherForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level);
        }
    }

    public void generateWitherForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level) {
        if (JavacHandlerUtil.hasAnnotation(Wither.class, fieldNode)) {
            return;
        }
        this.createWitherForField(level, fieldNode, fieldNode, false, List.<JCTree.JCAnnotation>nil(), List.<JCTree.JCAnnotation>nil());
    }

    @Override
    public void handle(AnnotationValues<Wither> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        HandlerUtil.handleExperimentalFlagUsage(annotationNode, ConfigurationKeys.WITHER_FLAG_USAGE, "@Wither");
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Wither.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE || node == null) {
            return;
        }
        List<JCTree.JCAnnotation> onMethod = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onMethod", "@Setter(onMethod=", annotationNode);
        List<JCTree.JCAnnotation> onParam = JavacHandlerUtil.unboxAndRemoveAnnotationParameter(ast, "onParam", "@Setter(onParam=", annotationNode);
        switch (node.getKind()) {
            case FIELD: {
                this.createWitherForFields(level, fields, annotationNode, true, onMethod, onParam);
                break;
            }
            case TYPE: {
                if (!onMethod.isEmpty()) {
                    annotationNode.addError("'onMethod' is not supported for @Wither on a type.");
                }
                if (!onParam.isEmpty()) {
                    annotationNode.addError("'onParam' is not supported for @Wither on a type.");
                }
                this.generateWitherForType(node, annotationNode, level, false);
            }
        }
    }

    public void createWitherForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists, List<JCTree.JCAnnotation> onMethod, List<JCTree.JCAnnotation> onParam) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createWitherForField(level, fieldNode, errorNode, whineIfExists, onMethod, onParam);
        }
    }

    public void createWitherForField(AccessLevel level, JavacNode fieldNode, JavacNode source, boolean whineIfExists, List<JCTree.JCAnnotation> onMethod, List<JCTree.JCAnnotation> onParam) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            fieldNode.addError("@Wither is only supported on a class or a field.");
            return;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        String methodName = JavacHandlerUtil.toWitherName(fieldNode);
        if (methodName == null) {
            fieldNode.addWarning("Not generating wither for this field: It does not fit your @Accessors prefix list.");
            return;
        }
        if ((fieldDecl.mods.flags & 8L) != 0L) {
            fieldNode.addWarning("Not generating wither for this field: Withers cannot be generated for static fields.");
            return;
        }
        if ((fieldDecl.mods.flags & 0x10L) != 0L && fieldDecl.init != null) {
            fieldNode.addWarning("Not generating wither for this field: Withers cannot be generated for final, initialized fields.");
            return;
        }
        if (fieldDecl.name.toString().startsWith("$")) {
            fieldNode.addWarning("Not generating wither for this field: Withers cannot be generated for fields starting with $.");
            return;
        }
        for (String altName : JavacHandlerUtil.toAllWitherNames(fieldNode)) {
            switch (JavacHandlerUtil.methodExists(altName, fieldNode, false, 1)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(methodName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        fieldNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", methodName, altNameExpl));
                    }
                    return;
                }
            }
        }
        long access = JavacHandlerUtil.toJavacModifier(level);
        JCTree.JCMethodDecl createdWither = this.createWither(access, fieldNode, fieldNode.getTreeMaker(), source, onMethod, onParam);
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), createdWither);
    }

    public JCTree.JCMethodDecl createWither(long access, JavacNode field, JavacTreeMaker maker, JavacNode source, List<JCTree.JCAnnotation> onMethod, List<JCTree.JCAnnotation> onParam) {
        String witherName = JavacHandlerUtil.toWitherName(field);
        if (witherName == null) {
            return null;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, HandlerUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, HandlerUtil.NULLABLE_PATTERN);
        Name methodName = field.toName(witherName);
        List<JCTree.JCAnnotation> annsOnParam = JavacHandlerUtil.copyAnnotations(onParam).appendList(nonNulls).appendList(nullables);
        long flags = JavacHandlerUtil.addFinalIfNeeded(0x200000000L, field.getContext());
        JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(flags, annsOnParam), fieldDecl.name, fieldDecl.vartype, null);
        JCTree.JCExpression selfType = JavacHandlerUtil.cloneSelfType(field);
        if (selfType == null) {
            return null;
        }
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        for (JavacNode child : ((JavacNode)field.up()).down()) {
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl childDecl = (JCTree.JCVariableDecl)child.get();
            if (childDecl.name.toString().startsWith("$") || ((fieldFlags = childDecl.mods.flags) & 8L) != 0L || (fieldFlags & 0x10L) != 0L && childDecl.init != null) continue;
            if (child.get() == field.get()) {
                args.append(maker.Ident(fieldDecl.name));
                continue;
            }
            args.append(JavacHandlerUtil.createFieldAccessor(maker, child, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD));
        }
        JCTree.JCNewClass newClass = maker.NewClass(null, List.<JCTree.JCExpression>nil(), selfType, args.toList(), null);
        JCTree.JCBinary identityCheck = maker.Binary(Javac.CTC_EQUAL, JavacHandlerUtil.createFieldAccessor(maker, field, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD), maker.Ident(fieldDecl.name));
        JCTree.JCConditional conditional = maker.Conditional(identityCheck, maker.Ident(field.toName("this")), newClass);
        JCTree.JCReturn returnStatement = maker.Return(conditional);
        if (nonNulls.isEmpty()) {
            statements.append(returnStatement);
        } else {
            JCTree.JCStatement nullCheck = JavacHandlerUtil.generateNullCheck(maker, field, source);
            if (nullCheck != null) {
                statements.append(nullCheck);
            }
            statements.append(returnStatement);
        }
        JCTree.JCExpression returnType = JavacHandlerUtil.cloneSelfType(field);
        JCTree.JCBlock methodBody = maker.Block(0L, statements.toList());
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.of(param);
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        List<JCTree.JCAnnotation> annsOnMethod = JavacHandlerUtil.copyAnnotations(onMethod);
        if (JavacHandlerUtil.isFieldDeprecated(field)) {
            annsOnMethod = annsOnMethod.prepend(maker.Annotation(JavacHandlerUtil.genJavaLangTypeRef(field, "Deprecated"), List.<JCTree.JCExpression>nil()));
        }
        JCTree.JCMethodDecl decl = JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(maker.Modifiers(access, annsOnMethod), methodName, returnType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue), (JCTree)source.get(), field.getContext());
        JavacHandlerUtil.copyJavadoc(field, decl, JavacHandlerUtil.CopyJavadoc.WITHER);
        return decl;
    }
}

