/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.management.DataStoreGarbageCollector;
import org.apache.jackrabbit.api.management.MarkEventListener;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.ScanEventListener;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector
implements DataStoreGarbageCollector {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollector.class);
    private MarkEventListener callback;
    private long sleepBetweenNodes;
    private int testDelay;
    private final DataStore store;
    private long startScanTimestamp;
    private final ArrayList<Listener> listeners = new ArrayList();
    private final IterablePersistenceManager[] pmList;
    private final Session[] sessionList;
    private SessionListener sessionListener;
    private final AtomicBoolean closed = new AtomicBoolean();
    private boolean persistenceManagerScan;

    public GarbageCollector(RepositoryImpl rep, SessionImpl session, IterablePersistenceManager[] list, Session[] sessionList) {
        this.store = rep.getDataStore();
        this.pmList = list;
        this.persistenceManagerScan = list != null;
        this.sessionList = sessionList;
        if (session != null) {
            this.sessionListener = new SessionListener(){

                public void loggedOut(SessionImpl session) {
                }

                public void loggingOut(SessionImpl session) {
                    GarbageCollector.this.close();
                }
            };
            session.addListener(this.sessionListener);
        }
    }

    public void setSleepBetweenNodes(long millis) {
        this.sleepBetweenNodes = millis;
    }

    public long getSleepBetweenNodes() {
        return this.sleepBetweenNodes;
    }

    public void setTestDelay(int testDelay) {
        this.testDelay = testDelay;
    }

    public void setScanEventListener(ScanEventListener callback) {
        this.setMarkEventListener(callback);
    }

    public void setMarkEventListener(MarkEventListener callback) {
        this.callback = callback;
    }

    public void scan() throws RepositoryException {
        this.mark();
    }

    public void mark() throws RepositoryException {
        if (this.store == null) {
            throw new RepositoryException("No DataStore configured.");
        }
        long now = System.currentTimeMillis();
        if (this.startScanTimestamp == 0L) {
            this.startScanTimestamp = now;
            this.store.updateModifiedDateOnAccess(this.startScanTimestamp);
        }
        if (this.pmList == null || !this.persistenceManagerScan) {
            for (Session s : this.sessionList) {
                this.scanNodes(s);
            }
        } else {
            try {
                this.scanPersistenceManagers();
            }
            catch (ItemStateException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void scanNodes(Session session) throws RepositoryException {
        this.listeners.add(new Listener(session));
        this.recurse(session.getRootNode(), this.sleepBetweenNodes);
    }

    public void setPersistenceManagerScan(boolean allow) {
        this.persistenceManagerScan = allow;
    }

    public boolean isPersistenceManagerScan() {
        return this.persistenceManagerScan;
    }

    public boolean getPersistenceManagerScan() {
        return this.isPersistenceManagerScan();
    }

    private void scanPersistenceManagers() throws RepositoryException, ItemStateException {
        for (IterablePersistenceManager pm : this.pmList) {
            for (NodeId id : pm.getAllNodeIds(null, 0)) {
                if (this.callback != null) {
                    this.callback.beforeScanning(null);
                }
                try {
                    NodeState state = pm.load(id);
                    Set<Name> propertyNames = state.getPropertyNames();
                    for (Name name : propertyNames) {
                        PropertyId pid = new PropertyId(id, name);
                        PropertyState ps = pm.load(pid);
                        if (ps.getType() != 2) continue;
                        for (InternalValue v : ps.getValues()) {
                            v.getLength();
                        }
                    }
                }
                catch (NoSuchItemStateException e) {
                }
            }
        }
    }

    public void stopScan() throws RepositoryException {
        if (this.listeners.size() > 0) {
            for (Listener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            this.listeners.clear();
        }
    }

    public int deleteUnused() throws RepositoryException {
        return this.sweep();
    }

    public int sweep() throws RepositoryException {
        if (this.startScanTimestamp == 0L) {
            throw new RepositoryException("scan must be called first");
        }
        this.stopScan();
        return this.store.deleteAllOlderThan(this.startScanTimestamp);
    }

    public DataStore getDataStore() {
        return this.store;
    }

    private void recurse(Node n, long sleep) throws RepositoryException {
        PropertyIterator it;
        if (sleep > 0L) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.callback != null) {
            this.callback.beforeScanning(n);
        }
        try {
            it = n.getProperties();
            while (it.hasNext()) {
                Property p = it.nextProperty();
                try {
                    if (p.getType() != 2) continue;
                    if (n.hasProperty("jcr:uuid")) {
                        this.rememberNode(n.getProperty("jcr:uuid").getString());
                    } else {
                        this.rememberNode(n.getPath());
                    }
                    if (p.isMultiple()) {
                        p.getLengths();
                        continue;
                    }
                    p.getLength();
                }
                catch (InvalidItemStateException e) {
                    LOG.debug("Property removed concurrently - ignoring", (Throwable)e);
                }
            }
        }
        catch (InvalidItemStateException e) {
            LOG.debug("Node removed concurrently - ignoring", (Throwable)e);
        }
        try {
            it = n.getNodes();
            while (it.hasNext()) {
                this.recurse(it.nextNode(), sleep);
            }
        }
        catch (InvalidItemStateException e) {
            LOG.debug("Node removed concurrently - ignoring", (Throwable)e);
        }
    }

    private void rememberNode(String path) {
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            try {
                this.stopScan();
            }
            catch (RepositoryException e) {
                LOG.warn("An error occured when stopping the event listener", (Throwable)e);
            }
            for (Session s : this.sessionList) {
                s.logout();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    class Listener
    implements SynchronousEventListener {
        private final Session session;
        private final ObservationManager manager;
        private Exception lastException;

        Listener(Session session) throws UnsupportedRepositoryOperationException, RepositoryException {
            this.session = session;
            Workspace ws = session.getWorkspace();
            this.manager = ws.getObservationManager();
            this.manager.addEventListener((EventListener)this, 1, "/", true, null, null, false);
        }

        void stop() throws Exception {
            if (this.lastException != null) {
                throw this.lastException;
            }
            this.manager.removeEventListener((EventListener)this);
        }

        public void onEvent(EventIterator events) {
            if (GarbageCollector.this.testDelay > 0) {
                try {
                    Thread.sleep(GarbageCollector.this.testDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            while (events.hasNext()) {
                Event event = events.nextEvent();
                try {
                    String path = event.getPath();
                    try {
                        Item item = this.session.getItem(path);
                        if (!item.isNode()) continue;
                        Node n = (Node)item;
                        GarbageCollector.this.recurse(n, GarbageCollector.this.testDelay);
                    }
                    catch (PathNotFoundException e) {
                    }
                }
                catch (Exception e) {
                    this.lastException = e;
                }
            }
        }
    }
}

