/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.walluck.oscar.client.Buddy;

class InfoWindow
extends JDialog {
    private static Map dialogs = new HashMap();
    private Buddy b;
    private String info;
    private String away;
    private JEditorPane pane;

    private InfoWindow(Buddy _b) {
        this.b = _b;
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JLabel label = new JLabel(this.b.getName() + "'s Info");
        content.add((Component)label, "North");
        this.pane = new JEditorPane();
        this.pane.setContentType("text/html");
        this.pane.setEditable(false);
        content.add((Component)new JScrollPane(this.pane), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        content.add((Component)buttonPanel, "South");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoWindow.this.dispose();
            }
        });
        buttonPanel.add(ok);
        this.setTitle("Get Info");
        this.setSize(320, 320);
        dialogs.put(this.b, this);
    }

    public static InfoWindow createInfoWindow(Buddy buddy) {
        if (dialogs.get(buddy) == null) {
            InfoWindow w = new InfoWindow(buddy);
            dialogs.put(buddy, w);
        }
        return (InfoWindow)dialogs.get(buddy);
    }

    private void redisplay() {
        if (this.away == null && this.info != null) {
            this.pane.setText(this.info);
        } else if (this.info == null && this.away != null) {
            this.pane.setText(this.away);
        } else if (this.info != null && this.away != null) {
            this.pane.setText(this.away + "<hr>" + this.info);
        } else {
            this.pane.setText("<i>No Information Provided</i>");
        }
    }

    public void append(String stuff) {
        if (this.away == null) {
            this.setAwayMsg(stuff);
        } else if (this.info == null) {
            this.setInfoMsg(stuff);
        } else {
            this.away = null;
            this.info = null;
            this.setAwayMsg(stuff);
        }
    }

    public void setAwayMsg(String _away) {
        this.away = _away;
        this.redisplay();
    }

    public void setInfoMsg(String _info) {
        this.info = _info;
        this.redisplay();
    }
}

