/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.session;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.application.framework.core.session.Notifier;
import org.gcube.application.framework.core.util.ASLGroupModel;
import org.gcube.application.framework.core.util.GenderType;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Deprecated
public class ASLSession {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Object> innerSession = new HashMap();
    private HttpSession session;
    private long lastUsedTime;
    private String externalSessionID;
    private String username;
    private String parentScope;
    private String scope;
    private String securityToken;
    private HashMap<String, Notifier> notifiers = new HashMap();
    String scopeName;
    private ASLGroupModel groupModel;
    private boolean loggedIn = false;
    private String userEmailAddress;
    private String fullName;
    private String avatarId;
    private GenderType gender;
    private long sessionTimeout = -1L;
    private static final Logger logger = LoggerFactory.getLogger(ASLSession.class);

    ASLSession(String externalSessionId, String user) {
        this.lastUsedTime = System.currentTimeMillis();
        this.username = user;
        this.externalSessionID = externalSessionId;
        this.groupModel = new ASLGroupModel();
    }

    ASLSession(HttpSession session, String user) {
        this(session.getId(), user);
        session.setAttribute("notifiers", new HashMap());
        session.setAttribute("lastUsedTime", (Object)System.currentTimeMillis());
        session.setAttribute("username", (Object)user);
        session.setAttribute("groupModel", (Object)new ASLGroupModel());
        this.session = session;
    }

    private void initializeAttributes() {
        if (this.session != null) {
            Enumeration sessAttrNames = this.session.getAttributeNames();
            while (sessAttrNames.hasMoreElements()) {
                String key = (String)sessAttrNames.nextElement();
                if (!key.equals("collectionsPresentableFields") && !key.equals("collectionsHierarchy")) continue;
                this.session.removeAttribute(key);
                break;
            }
        } else {
            for (String key : this.innerSession.keySet()) {
                if (!key.equals("collectionsPresentableFields") && !key.equals("collectionsHierarchy")) continue;
                this.innerSession.remove(key);
                break;
            }
        }
    }

    public long getSessionTimeoutMillis() throws IOException, ParserConfigurationException {
        int timeoutMins;
        if (this.session != null) {
            return this.session.getMaxInactiveInterval() * 1000;
        }
        if (this.sessionTimeout > 0L) {
            return this.sessionTimeout;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        String tomcatBasePath = System.getProperty("catalina.base");
        String fullFilePath = tomcatBasePath + "/webapps/ROOT/WEB-INF/web.xml";
        Document webXMLDoc = null;
        try {
            File webXML = new File(fullFilePath);
            webXMLDoc = dBuilder.parse(webXML);
            webXMLDoc.getDocumentElement().normalize();
            NodeList sessionTimeouts = webXMLDoc.getElementsByTagName("session-timeout");
            String timeoutString = sessionTimeouts.item(0).getTextContent();
            if (timeoutString == null || timeoutString == "") {
                logger.debug("No property session-timeout in file, setting it to default");
                timeoutMins = 30;
            } else {
                timeoutMins = Integer.parseInt(timeoutString) + 5;
            }
        }
        catch (Exception e) {
            logger.debug("Could not parse file " + fullFilePath + " for session-timeout property. Parsing from jar.");
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL url = classLoader.getResource("/properties.xml");
                webXMLDoc = dBuilder.parse(new File(url.toURI()));
                webXMLDoc.getDocumentElement().normalize();
                NodeList sessionTimeouts = webXMLDoc.getElementsByTagName("session-timeout");
                String timeoutString = sessionTimeouts.item(0).getTextContent();
                if (timeoutString == null || timeoutString == "") {
                    logger.debug("No property session-timeout in local file, setting it to default");
                    timeoutMins = 30;
                } else {
                    timeoutMins = Integer.parseInt(timeoutString);
                }
            }
            catch (Exception e1) {
                logger.debug("Could not parse file properties.xml for property. Setting it to default.");
                timeoutMins = 30;
            }
        }
        this.sessionTimeout = timeoutMins * 60000;
        logger.info("Session Timeout is: " + this.sessionTimeout);
        return this.sessionTimeout;
    }

    public long increaseSessionTimeout(long milliseconds, boolean resetCounting) {
        if (this.session != null) {
            int secs = (int)milliseconds / 1000;
            this.session.setMaxInactiveInterval(this.session.getMaxInactiveInterval() + secs);
            return this.session.getMaxInactiveInterval() * 1000;
        }
        if (resetCounting) {
            this.lastUsedTime = System.currentTimeMillis();
        }
        this.sessionTimeout += milliseconds;
        return this.sessionTimeout;
    }

    public boolean isValid() {
        if (this.session != null) {
            try {
                this.session.getCreationTime();
            }
            catch (IllegalStateException ise) {
                return false;
            }
            return true;
        }
        long maxTime = -1L;
        try {
            maxTime = this.getSessionTimeoutMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return System.currentTimeMillis() - this.lastUsedTime <= maxTime;
    }

    @Deprecated
    public boolean isEmpty() {
        if (this.session != null) {
            return this.getAttributeNames().isEmpty();
        }
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.isEmpty();
    }

    public boolean hasAttribute(String name) {
        if (this.session != null) {
            this.lastUsedTime = System.currentTimeMillis();
            if (this.innerSession.containsKey(name)) {
                return true;
            }
            if (!this.innerSession.containsKey(name) && this.session.getAttribute(name) == null) {
                return false;
            }
            if (!this.innerSession.containsKey(name) && this.session.getAttribute(name) != null) {
                this.innerSession.put(name, this.session.getAttribute(name));
                return true;
            }
            return false;
        }
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.containsKey(name);
    }

    public Set<String> getAttributeNames() {
        if (this.session != null) {
            Enumeration names = this.session.getAttributeNames();
            HashSet<String> output = new HashSet<String>();
            while (names.hasMoreElements()) {
                output.add((String)names.nextElement());
            }
            output.addAll(this.innerSession.keySet());
            return output;
        }
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.keySet();
    }

    @Deprecated
    public Object getAttribute(String name) {
        if (this.session != null) {
            this.lastUsedTime = System.currentTimeMillis();
            Object innerObj = this.innerSession.get(name);
            Object httpObj = this.session.getAttribute(name);
            if (innerObj != null) {
                return innerObj;
            }
            if (httpObj != null) {
                this.innerSession.put(name, httpObj);
                return httpObj;
            }
            return null;
        }
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.get(name);
    }

    @Deprecated
    public void setAttribute(String name, Object value) {
        if (this.session != null) {
            this.session.setAttribute(name, value);
        }
        this.lastUsedTime = System.currentTimeMillis();
        this.innerSession.put(name, value);
    }

    public String getOriginalScopeName() {
        if (this.session != null) {
            String httpSessionScope = (String)this.session.getAttribute("scopeName");
            if (this.scopeName != null) {
                return this.scopeName;
            }
            if (httpSessionScope != null) {
                this.scopeName = httpSessionScope;
                return httpSessionScope;
            }
            return null;
        }
        return this.scopeName;
    }

    @Deprecated
    public Object removeAttribute(String name) {
        if (this.session != null) {
            this.lastUsedTime = System.currentTimeMillis();
            Object httpAttrib = this.session.getAttribute(name);
            this.session.removeAttribute(name);
            Object innerAttrib = this.innerSession.remove(name);
            return httpAttrib == null ? innerAttrib : httpAttrib;
        }
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.remove(name);
    }

    @Deprecated
    public void removeAll() {
        if (this.session != null) {
            for (String name : this.getAttributeNames()) {
                this.session.removeAttribute(name);
            }
        }
        this.lastUsedTime = System.currentTimeMillis();
        this.innerSession.clear();
    }

    public String getParentScope() {
        ScopeBean bean = new ScopeBean(this.getScope());
        return bean.enclosingScope().toString();
    }

    public void invalidate() {
        if (this.session != null) {
            this.session.setMaxInactiveInterval(0);
        }
        long maxTime = -1L;
        try {
            maxTime = this.getSessionTimeoutMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastUsedTime = System.currentTimeMillis() - maxTime - 120000L;
    }

    public String getExternalSessionID() {
        if (this.session != null) {
            return this.session.getId();
        }
        return this.externalSessionID;
    }

    public String getUsername() {
        if (this.session != null) {
            String httpUN = (String)this.session.getAttribute("username");
            if (this.username != null) {
                return this.username;
            }
            if (httpUN != null) {
                this.username = httpUN;
                return httpUN;
            }
            return null;
        }
        return this.username;
    }

    public String getScope() {
        if (this.session != null) {
            String httpScope = (String)this.session.getAttribute("scope");
            if (this.scope != null) {
                return this.scope;
            }
            if (httpScope != null) {
                this.scope = httpScope;
                return httpScope;
            }
            return null;
        }
        if (this.scope == null) {
            logger.debug("Scope is null, returning null");
        }
        return this.scope;
    }

    public String getScopeName() {
        if (this.session != null) {
            String httpScope = (String)this.session.getAttribute("scope");
            if (this.scope != null) {
                return this.scope;
            }
            if (httpScope != null) {
                this.scope = httpScope;
                return httpScope;
            }
            return null;
        }
        if (this.scope == null) {
            logger.debug("Scope is null, returning null");
        }
        return this.scope;
    }

    public void setScope(String scope) {
        String previousScopeName = null;
        if (this.session != null) {
            logger.info("The scope about to set is: " + scope);
            previousScopeName = (String)this.session.getAttribute("scope");
            this.session.setAttribute("scope", (Object)scope);
            this.session.setAttribute("scopeName", (Object)scope);
            ScopeProvider.instance.set(scope);
        }
        logger.info("The scope about to set is: " + scope);
        this.lastUsedTime = System.currentTimeMillis();
        previousScopeName = this.scopeName;
        this.scope = scope;
        this.scopeName = scope;
        ScopeProvider.instance.set(scope);
        if (this.loggedIn) {
            this.initializeAttributes();
            this.loggedIn = false;
            logger.debug("Passing the logging because the variable was set");
            return;
        }
        if (previousScopeName != null && !previousScopeName.equals(this.getScope()) || previousScopeName == null) {
            logger.info("Logging the entrance");
        } else {
            logger.debug("Passing the logging because the scope was the same");
        }
        this.initializeAttributes();
    }

    private void addNotifier(String key, Notifier value) {
        if (this.session != null) {
            ((HashMap)this.session.getAttribute("notifiers")).put(key, value);
        } else {
            logger.error("Could not set notifier for " + key);
        }
    }

    private Notifier getNotifier(String key) {
        if (this.session != null) {
            return (Notifier)((HashMap)this.session.getAttribute("notifiers")).get(key);
        }
        logger.error("Could not get notifier for " + key + " because HTTPSession was null. WILL RETURN NULL NOTIFIER");
        return null;
    }

    public void setSecurityToken(String token) {
        if (this.session != null) {
            SecurityTokenProvider.instance.set(token);
            this.session.setAttribute("securityToken", (Object)token);
        }
        this.securityToken = token;
    }

    public void logUserLogin(String scope) {
        this.loggedIn = true;
    }

    public void waitNotification(String notification) throws InterruptedException {
        Notifier notifier = this.getNotifier(notification);
        if (notifier == null) {
            notifier = new Notifier();
            this.addNotifier(notification, notifier);
        }
        this.lastUsedTime = System.currentTimeMillis();
        notifier.waitNotification();
    }

    public void notifyAllWaiting(String notification) throws InterruptedException {
        Notifier notifier = this.getNotifier(notification);
        if (notifier == null) {
            notifier = new Notifier();
            this.addNotifier(notification, notifier);
        }
        this.lastUsedTime = System.currentTimeMillis();
        notifier.notifyAllWaiting();
    }

    public void setGroupModelInfos(String groupName, long groupId) {
        if (this.session != null) {
            ASLGroupModel aslGM = (ASLGroupModel)this.session.getAttribute("groupModel");
            aslGM.setGroupName(groupName);
            aslGM.setGroupId(groupId);
            this.session.setAttribute("groupModel", (Object)aslGM);
        } else {
            this.groupModel.setGroupName(groupName);
            this.groupModel.setGroupId(groupId);
        }
    }

    public long getGroupId() {
        if (this.session != null) {
            ASLGroupModel agmHttp = (ASLGroupModel)this.session.getAttribute("groupModel");
            if (this.groupModel != null) {
                return this.groupModel.getGroupId();
            }
            if (agmHttp != null) {
                this.groupModel = agmHttp;
                return agmHttp.getGroupId();
            }
            return Long.MIN_VALUE;
        }
        return this.groupModel.getGroupId();
    }

    public String getGroupName() {
        if (this.session != null) {
            ASLGroupModel agmHttp = (ASLGroupModel)this.session.getAttribute("groupModel");
            if (this.groupModel != null) {
                return this.groupModel.getGroupName();
            }
            if (agmHttp != null) {
                this.groupModel = agmHttp;
                return agmHttp.getGroupName();
            }
            return null;
        }
        return this.groupModel.getGroupName();
    }

    public void setUserEmailAddress(String email) {
        if (this.session != null) {
            this.session.setAttribute("userEmailAddress", (Object)email);
        }
        this.userEmailAddress = email;
    }

    public String getUserEmailAddress() {
        if (this.session != null) {
            String httpUEA = (String)this.session.getAttribute("userEmailAddress");
            if (this.userEmailAddress != null) {
                return this.userEmailAddress;
            }
            if (httpUEA != null) {
                this.userEmailAddress = httpUEA;
                return httpUEA;
            }
            return null;
        }
        return this.userEmailAddress;
    }

    public void setUserFullName(String fullName) {
        if (this.session != null) {
            this.session.setAttribute("fullName", (Object)fullName);
        }
        this.fullName = fullName;
    }

    public String getUserFullName() {
        if (this.session != null) {
            String httpFN = (String)this.session.getAttribute("fullName");
            if (this.fullName != null) {
                return this.fullName;
            }
            if (httpFN != null) {
                this.fullName = httpFN;
                return httpFN;
            }
            return null;
        }
        return this.fullName;
    }

    public void setUserAvatarId(String avatarId) {
        if (this.session != null) {
            this.session.setAttribute("avatarId", (Object)avatarId);
        }
        this.avatarId = avatarId;
    }

    public String getUserAvatarId() {
        if (this.session != null) {
            String httpUAid = (String)this.session.getAttribute("avatarId");
            if (this.avatarId != null) {
                return this.avatarId;
            }
            if (httpUAid != null) {
                this.avatarId = httpUAid;
                return httpUAid;
            }
            return null;
        }
        return this.avatarId;
    }

    public void setUserGender(GenderType gender) {
        if (this.session != null) {
            this.session.setAttribute("gender", (Object)gender);
        }
        this.gender = gender;
    }

    public GenderType getUserGender() {
        if (this.session != null) {
            Object httpGObj = this.session.getAttribute("gender");
            if (this.gender != null) {
                return this.gender;
            }
            if (httpGObj != null) {
                this.gender = (GenderType)((Object)httpGObj);
                return (GenderType)((Object)httpGObj);
            }
            return null;
        }
        return this.gender;
    }

    public String getSecurityToken() {
        if (this.session != null) {
            String httpSecurityToken = (String)this.session.getAttribute("securityToken");
            if (this.securityToken != null) {
                logger.debug("Getting security token: " + this.securityToken + " in thread " + Thread.currentThread().getId());
                return this.securityToken;
            }
            if (httpSecurityToken != null) {
                logger.debug("Getting security token: " + httpSecurityToken + " in thread " + Thread.currentThread().getId());
                this.securityToken = httpSecurityToken;
                return httpSecurityToken;
            }
            return null;
        }
        logger.debug("Getting security token: " + this.securityToken + " in thread " + Thread.currentThread().getId());
        return this.securityToken;
    }
}

