/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.portletconfiguration.action.ActionUtil;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditSupportedClientsAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        PortletPreferences portletPreferences = ActionUtil.getLayoutPortletSetup((PortletRequest)actionRequest, portlet);
        actionRequest = ActionUtil.getWrappedActionRequest(actionRequest, portletPreferences);
        this.updateSupportedClients(portlet, actionRequest);
        this.sendRedirect(actionRequest, actionResponse);
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = ActionUtil.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return actionMapping.findForward("portlet.portlet_configuration.error");
        }
        PortletPreferences portletPreferences = ActionUtil.getLayoutPortletSetup((PortletRequest)renderRequest, portlet);
        renderRequest = ActionUtil.getWrappedRenderRequest(renderRequest, portletPreferences);
        renderResponse.setTitle(ActionUtil.getTitle(portlet, renderRequest));
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_supported_clients"));
    }

    protected void updateSupportedClients(Portlet portlet, ActionRequest actionRequest) throws Exception {
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        Set allPortletModes = portlet.getAllPortletModes();
        for (String portletMode : allPortletModes) {
            String mobileDevicesParam = "portletSetupSupportedClientsMobileDevices_" + portletMode;
            boolean mobileDevices = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)mobileDevicesParam);
            portletPreferences.setValue(mobileDevicesParam, String.valueOf(mobileDevices));
        }
        portletPreferences.store();
    }
}

