/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.AltBridgeTransformer;
import org.portletbridge.portlet.BridgeAuthenticator;
import org.portletbridge.portlet.BridgeEditPortlet;
import org.portletbridge.portlet.BridgeFunctionsFactory;
import org.portletbridge.portlet.BridgeHelpPortlet;
import org.portletbridge.portlet.BridgeViewPortlet;
import org.portletbridge.portlet.DefaultHttpClientTemplate;
import org.portletbridge.portlet.DefaultIdGenerator;
import org.portletbridge.portlet.DefaultTemplateFactory;
import org.portletbridge.portlet.IdGenerator;
import org.portletbridge.portlet.PortletFunctions;
import org.portletbridge.portlet.RegexContentRewriter;
import org.portletbridge.portlet.TemplateFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PortletBridgePortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$portletbridge$portlet$PortletBridgePortlet == null ? (class$org$portletbridge$portlet$PortletBridgePortlet = PortletBridgePortlet.class$("org.portletbridge.portlet.PortletBridgePortlet")) : class$org$portletbridge$portlet$PortletBridgePortlet));
    private Portlet viewPortlet = null;
    private Portlet editPortlet = null;
    private Portlet helpPortlet = null;
    private Templates errorTemplates = null;
    static /* synthetic */ Class class$org$portletbridge$portlet$PortletBridgePortlet;

    public void init() throws PortletException {
        DefaultTemplateFactory templateFactory = new DefaultTemplateFactory();
        ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("org.portletbridge.portlet.PortletBridgePortlet");
        this.viewPortlet = this.createViewPortlet(resourceBundle, templateFactory);
        this.editPortlet = this.createEditPortlet(resourceBundle, templateFactory);
        this.helpPortlet = this.createHelpPortlet(resourceBundle, templateFactory);
        this.createErrorTemplates(resourceBundle, templateFactory);
        if (this.viewPortlet != null) {
            this.viewPortlet.init(this.getPortletConfig());
        }
        if (this.editPortlet != null) {
            this.editPortlet.init(this.getPortletConfig());
        }
        if (this.helpPortlet != null) {
            this.helpPortlet.init(this.getPortletConfig());
        }
    }

    protected void createErrorTemplates(ResourceBundle resourceBundle, TemplateFactory templateFactory) throws PortletException {
        String errorStylesheet = this.getPortletConfig().getInitParameter("errorStylesheet");
        if (errorStylesheet == null) {
            throw new PortletException(resourceBundle.getString("error.error.stylesheet"));
        }
        try {
            this.errorTemplates = templateFactory.getTemplatesFromUrl(errorStylesheet);
        }
        catch (ResourceException e) {
            throw new PortletException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected BridgeEditPortlet createEditPortlet(ResourceBundle resourceBundle, TemplateFactory templateFactory) throws PortletException {
        PortletConfig config = this.getPortletConfig();
        String editStylesheet = config.getInitParameter("editStylesheet");
        if (editStylesheet == null) {
            throw new PortletException(resourceBundle.getString("error.edit.stylesheet"));
        }
        BridgeEditPortlet bridgeEditPortlet = new BridgeEditPortlet();
        try {
            bridgeEditPortlet.setTemplates(templateFactory.getTemplatesFromUrl(editStylesheet));
        }
        catch (ResourceException e) {
            throw new PortletException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new PortletException((Throwable)e);
        }
        return bridgeEditPortlet;
    }

    protected BridgeHelpPortlet createHelpPortlet(ResourceBundle resourceBundle, TemplateFactory templateFactory) throws PortletException {
        PortletConfig config = this.getPortletConfig();
        String editStylesheet = config.getInitParameter("helpStylesheet");
        if (editStylesheet == null) {
            throw new PortletException(resourceBundle.getString("error.help.stylesheet"));
        }
        BridgeHelpPortlet bridgeHelpPortlet = new BridgeHelpPortlet();
        try {
            bridgeHelpPortlet.setTemplates(templateFactory.getTemplatesFromUrl(editStylesheet));
        }
        catch (ResourceException e) {
            throw new PortletException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new PortletException((Throwable)e);
        }
        return bridgeHelpPortlet;
    }

    protected BridgeViewPortlet createViewPortlet(ResourceBundle resourceBundle, TemplateFactory templateFactory) throws PortletException {
        PortletConfig config = this.getPortletConfig();
        String mementoSessionKey = config.getInitParameter("mementoSessionKey");
        if (mementoSessionKey == null) {
            throw new PortletException(resourceBundle.getString("error.mementoSessionKey"));
        }
        String servletName = config.getInitParameter("servletName");
        if (servletName == null) {
            throw new PortletException(resourceBundle.getString("error.servletName"));
        }
        String parserClassName = config.getInitParameter("parserClassName");
        if (parserClassName == null) {
            throw new PortletException(resourceBundle.getString("error.parserClassName"));
        }
        String authenticatorClassName = config.getInitParameter("authenticatorClassName");
        if (authenticatorClassName == null) {
            throw new PortletException(resourceBundle.getString("error.authenticatorClassName"));
        }
        BridgeAuthenticator bridgeAuthenticator = null;
        try {
            Class<?> authenticatorClass = Class.forName(authenticatorClassName);
            bridgeAuthenticator = (BridgeAuthenticator)authenticatorClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)e, (Throwable)e);
            throw new PortletException(resourceBundle.getString("error.authenticator"));
        }
        catch (InstantiationException e) {
            log.warn((Object)e, (Throwable)e);
            throw new PortletException(resourceBundle.getString("error.authenticator"));
        }
        catch (IllegalAccessException e) {
            log.warn((Object)e, (Throwable)e);
            throw new PortletException(resourceBundle.getString("error.authenticator"));
        }
        String idParamKey = config.getInitParameter("idParamKey");
        AltBridgeTransformer transformer = null;
        try {
            String cssRegex = config.getInitParameter("cssRegex");
            String javascriptRegex = config.getInitParameter("jsRegex");
            XMLReader parser = XMLReaderFactory.createXMLReader(parserClassName);
            Enumeration names = config.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.startsWith("parserFeature-")) {
                    parser.setFeature(name.substring("parserFeature-".length()), "true".equalsIgnoreCase(config.getInitParameter(name)));
                    continue;
                }
                if (!name.startsWith("parserProperty-")) continue;
                parser.setProperty(name.substring("parserProperty-".length()), config.getInitParameter(name));
            }
            IdGenerator idGenerator = DefaultIdGenerator.getInstance();
            RegexContentRewriter javascriptRewriter = new RegexContentRewriter(javascriptRegex);
            RegexContentRewriter cssRewriter = new RegexContentRewriter(cssRegex);
            BridgeFunctionsFactory bridgeFunctionsFactory = new BridgeFunctionsFactory(idGenerator, javascriptRewriter, cssRewriter);
            transformer = new AltBridgeTransformer(bridgeFunctionsFactory, templateFactory, parser, servletName);
        }
        catch (SAXNotRecognizedException e) {
            throw new PortletException((Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new PortletException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PortletException((Throwable)e);
        }
        BridgeViewPortlet bridgeViewPortlet = new BridgeViewPortlet();
        bridgeViewPortlet.setHttpClientTemplate(new DefaultHttpClientTemplate());
        bridgeViewPortlet.setTransformer(transformer);
        bridgeViewPortlet.setMementoSessionKey(mementoSessionKey);
        bridgeViewPortlet.setBridgeAuthenticator(bridgeAuthenticator);
        if (idParamKey != null) {
            bridgeViewPortlet.setIdParamKey(idParamKey);
        }
        return bridgeViewPortlet;
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            super.render(request, response);
        }
        catch (Throwable exception) {
            log.warn((Object)exception, exception);
            response.setContentType("text/html");
            try {
                Transformer transformer = this.errorTemplates.newTransformer();
                transformer.setParameter("portlet", new PortletFunctions(request, response));
                transformer.setParameter("exception", exception);
                transformer.transform(new StreamSource(new StringReader("<xml/>")), new StreamResult(response.getWriter()));
            }
            catch (TransformerConfigurationException e) {
                throw new PortletException((Throwable)e);
            }
            catch (TransformerException e) {
                throw new PortletException((Throwable)e);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.viewPortlet != null) {
            this.viewPortlet.render(request, response);
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.editPortlet != null) {
            this.editPortlet.render(request, response);
        }
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.helpPortlet != null) {
            this.helpPortlet.render(request, response);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletMode portletMode = request.getPortletMode();
        if (portletMode.equals((Object)PortletMode.VIEW)) {
            this.viewPortlet.processAction(request, response);
        } else if (portletMode.equals((Object)PortletMode.EDIT)) {
            this.editPortlet.processAction(request, response);
        } else if (portletMode.equals((Object)PortletMode.HELP)) {
            this.helpPortlet.processAction(request, response);
        }
    }

    public Portlet getEditPortlet() {
        return this.editPortlet;
    }

    public void setEditPortlet(Portlet editPortlet) {
        this.editPortlet = editPortlet;
    }

    public Portlet getHelpPortlet() {
        return this.helpPortlet;
    }

    public void setHelpPortlet(Portlet helpPortlet) {
        this.helpPortlet = helpPortlet;
    }

    public Portlet getViewPortlet() {
        return this.viewPortlet;
    }

    public void setViewPortlet(Portlet viewPortlet) {
        this.viewPortlet = viewPortlet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

