/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.cache;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;

public class Serializers {

    private static class RevisionedMapSerializer
    extends MapSerializer {
        public RevisionedMapSerializer(Kryo kryo) {
            this.setKeysCanBeNull(false);
            this.setKeyClass(Revision.class, kryo.getSerializer(Revision.class));
        }

        protected Map create(Kryo kryo, Input input, Class<Map> type) {
            return new TreeMap(StableRevisionComparator.REVERSE);
        }
    }

    public static class NodeDocumentSerializer
    extends Serializer<NodeDocument> {
        private final DocumentStore documentStore;

        public NodeDocumentSerializer(DocumentStore documentStore) {
            this.documentStore = documentStore;
        }

        public void write(Kryo kryo, Output o, NodeDocument doc) {
            Preconditions.checkArgument((boolean)doc.isSealed(), (String)"Cannot serialized non seal document [%s]", (Object[])new Object[]{doc.getId()});
            o.writeLong(doc.getCreated(), true);
            Set<String> keys = doc.keySet();
            o.writeInt(keys.size(), true);
            for (String key : doc.keySet()) {
                o.writeString(key);
                Object val = doc.get(key);
                if (val instanceof NavigableMap) {
                    kryo.writeClass(o, NavigableMap.class);
                    new RevisionedMapSerializer(kryo).write(kryo, o, (Map)val);
                    continue;
                }
                kryo.writeClass(o, val.getClass());
                kryo.writeObject(o, val);
            }
        }

        public NodeDocument read(Kryo kryo, Input input, Class<NodeDocument> nodeDocumentClass) {
            long created = input.readLong(true);
            int mapSize = input.readInt(true);
            NodeDocument doc = new NodeDocument(this.documentStore, created);
            for (int i = 0; i < mapSize; ++i) {
                String key = input.readString();
                Registration reg = kryo.readClass(input);
                Object value = reg.getType() == NavigableMap.class ? new RevisionedMapSerializer(kryo).read(kryo, input, Map.class) : kryo.readObject(input, reg.getType());
                doc.put(key, value);
            }
            doc.seal();
            return doc;
        }
    }

    public static class RevisionSerizlizer
    extends Serializer<Revision> {
        public void write(Kryo kryo, Output o, Revision r) {
            o.writeLong(r.getTimestamp(), true);
            o.writeInt(r.getCounter(), true);
            o.writeInt(r.getClusterId(), true);
            o.writeBoolean(r.isBranch());
        }

        public Revision read(Kryo kryo, Input i, Class<Revision> revisionClass) {
            return new Revision(i.readLong(true), i.readInt(true), i.readInt(true), i.readBoolean());
        }
    }
}

