/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.aggregate;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class AggregateIndex
implements QueryIndex.FulltextQueryIndex {
    private final QueryIndex.FulltextQueryIndex baseIndex;

    public AggregateIndex(QueryIndex.FulltextQueryIndex baseIndex) {
        this.baseIndex = baseIndex;
    }

    @Override
    public double getCost(Filter filter, NodeState rootState) {
        if (this.baseIndex == null) {
            return Double.POSITIVE_INFINITY;
        }
        double localCost = Double.POSITIVE_INFINITY;
        FullTextExpression e = filter.getFullTextConstraint();
        if (e != null && AggregateIndex.hasCompositeExpression(e)) {
            localCost = AggregateIndex.flattenCost(e, filter, this.baseIndex, rootState);
        }
        double baseCost = this.baseIndex.getCost(filter, rootState);
        return Math.min(localCost, baseCost) - 0.05;
    }

    @Override
    public Cursor query(Filter filter, NodeState rootState) {
        if (this.baseIndex.getNodeAggregator() == null) {
            return this.baseIndex.query(filter, rootState);
        }
        return AggregateIndex.newCursor(filter, this.baseIndex, rootState);
    }

    private static Cursor newCursor(Filter f, QueryIndex.FulltextQueryIndex index, NodeState state) {
        Cursor c;
        FullTextExpression e = f.getFullTextConstraint();
        if (AggregateIndex.hasCompositeExpression(e) && (c = AggregateIndex.flatten(e, f, index, state)) != null) {
            return c;
        }
        return new AggregationCursor(index.query(AggregateIndex.newAggregationFilter(f, null), state), index.getNodeAggregator(), state);
    }

    private static boolean hasCompositeExpression(FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final AtomicReference<Boolean> composite = new AtomicReference<Boolean>();
        composite.set(false);
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextTerm term) {
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                composite.set(true);
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                composite.set(true);
                return true;
            }
        });
        return (Boolean)composite.get() != false && !AggregateIndex.hasNegativeContains(ft);
    }

    private static boolean hasNegativeContains(FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final AtomicReference<Boolean> hasNegative = new AtomicReference<Boolean>();
        hasNegative.set(false);
        ft.accept(new FullTextVisitor.FullTextVisitorBase(){

            @Override
            public boolean visit(FullTextTerm term) {
                if (term.isNot()) {
                    hasNegative.set(true);
                }
                return true;
            }
        });
        return (Boolean)hasNegative.get();
    }

    private static Cursor flatten(FullTextExpression constraint, final Filter filter, final QueryIndex.FulltextQueryIndex index, final NodeState state) {
        if (constraint == null) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        constraint.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextTerm term) {
                result.set(AggregateIndex.filterToCursor(AggregateIndex.newAggregationFilter(filter, term), index, state));
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                Iterator<FullTextExpression> iterator = and.list.iterator();
                Cursor c = AggregateIndex.flatten(iterator.next(), filter, index, state);
                while (iterator.hasNext()) {
                    FullTextExpression input = iterator.next();
                    Cursor newC = AggregateIndex.flatten(input, filter, index, state);
                    c = Cursors.newIntersectionCursor(c, newC, filter.getQueryEngineSettings());
                }
                result.set(c);
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                List cursors = Lists.transform(or.list, (Function)new Function<FullTextExpression, Cursor>(){

                    public Cursor apply(FullTextExpression input) {
                        return AggregateIndex.flatten(input, filter, index, state);
                    }
                });
                result.set(Cursors.newConcatCursor(cursors, filter.getQueryEngineSettings()));
                return true;
            }
        });
        return (Cursor)result.get();
    }

    private static double flattenCost(FullTextExpression constraint, final Filter filter, final QueryIndex.FulltextQueryIndex index, final NodeState state) {
        if (constraint == null) {
            return Double.POSITIVE_INFINITY;
        }
        final AtomicReference<Double> result = new AtomicReference<Double>();
        result.set(0.0);
        constraint.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextTerm term) {
                result.set((Double)result.get() + index.getCost(AggregateIndex.newAggregationFilter(filter, term), state));
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                for (FullTextExpression input : and.list) {
                    double d = AggregateIndex.flattenCost(input, filter, index, state);
                    result.set((Double)result.get() + d);
                }
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                for (FullTextExpression input : or.list) {
                    double d = AggregateIndex.flattenCost(input, filter, index, state);
                    result.set((Double)result.get() + d);
                }
                return true;
            }
        });
        return (Double)result.get();
    }

    private static Cursor filterToCursor(Filter f, QueryIndex.FulltextQueryIndex index, NodeState state) {
        return new AggregationCursor(index.query(f, state), index.getNodeAggregator(), state);
    }

    private static Filter newAggregationFilter(Filter filter, FullTextExpression exp) {
        FilterImpl f = new FilterImpl(filter);
        f.setMatchesAllTypes(true);
        if (exp != null) {
            f.setFullTextConstraint(exp);
        }
        return f;
    }

    @Override
    public String getPlan(Filter filter, NodeState rootState) {
        if (this.baseIndex == null) {
            return "aggregate no-index";
        }
        return "aggregate " + this.baseIndex.getPlan(filter, rootState);
    }

    @Override
    public String getIndexName() {
        if (this.baseIndex == null) {
            return "aggregate no-index";
        }
        return "aggregate " + this.baseIndex.getIndexName();
    }

    @Override
    public NodeAggregator getNodeAggregator() {
        return this.baseIndex.getNodeAggregator();
    }

    private static class AggregationCursor
    extends Cursors.AbstractCursor {
        private final Cursor cursor;
        private final NodeAggregator aggregator;
        private final NodeState rootState;
        private boolean init;
        private boolean closed;
        private IndexRow currentRow;
        private String currentPath;
        private Iterator<String> aggregates;
        private Set<String> seenPaths = new HashSet<String>();

        public AggregationCursor(Cursor cursor, NodeAggregator aggregator, NodeState rootState) {
            this.cursor = cursor;
            this.aggregator = aggregator;
            this.rootState = rootState;
        }

        @Override
        public boolean hasNext() {
            if (!this.closed && !this.init) {
                this.fetchNext();
                this.init = true;
            }
            return !this.closed;
        }

        private void fetchNext() {
            if (this.aggregates != null && this.aggregates.hasNext()) {
                this.currentPath = this.aggregates.next();
                this.init = true;
                return;
            }
            this.aggregates = null;
            if (this.cursor.hasNext()) {
                this.currentRow = this.cursor.next();
                String path = this.currentRow.getPath();
                this.aggregates = Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.singletonIterator((Object)path), this.aggregator.getParents(this.rootState, path)), (Predicate)Predicates.not((Predicate)Predicates.in(this.seenPaths)));
                this.fetchNext();
                return;
            }
            this.closed = true;
        }

        @Override
        public IndexRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.seenPaths.add(this.currentPath);
            this.init = false;
            if (this.currentRow.getPath().equals(this.currentPath)) {
                return this.currentRow;
            }
            return new IndexRow(){

                @Override
                public String getPath() {
                    return AggregationCursor.this.currentPath;
                }

                @Override
                public PropertyValue getValue(String columnName) {
                    return AggregationCursor.this.currentRow.getValue(columnName);
                }
            };
        }
    }
}

