/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.strategy;

import com.google.common.collect.Iterators;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMirrorStoreStrategy
implements IndexStoreStrategy {
    static final Logger LOG = LoggerFactory.getLogger(ContentMirrorStoreStrategy.class);

    @Override
    public void update(NodeBuilder index, String path, Set<String> beforeKeys, Set<String> afterKeys) {
        for (String key : beforeKeys) {
            this.remove(index, key, path);
        }
        for (String key : afterKeys) {
            this.insert(index, key, path);
        }
    }

    private void remove(NodeBuilder index, String key, String value) {
        NodeBuilder builder = index.getChildNode(key);
        if (builder.exists()) {
            ArrayDeque builders = Queues.newArrayDeque();
            builders.addFirst(builder);
            for (String name : PathUtils.elements((String)value)) {
                builder = builder.getChildNode(name);
                builders.addFirst(builder);
            }
            if (builder.exists()) {
                builder.removeProperty("match");
            }
            this.prune(index, builders);
        }
    }

    private void insert(NodeBuilder index, String key, String value) {
        NodeBuilder builder = this.fetchKeyNode(index, key);
        for (String name : PathUtils.elements((String)value)) {
            builder = builder.child(name);
        }
        builder.setProperty("match", true);
    }

    public Iterable<String> query(final Filter filter, final String indexName, NodeState indexMeta, String indexStorageNodeName, final Iterable<String> values) {
        final NodeState index = indexMeta.getChildNode(indexStorageNodeName);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                PathIterator it = new PathIterator(filter, indexName);
                if (values == null) {
                    it.setPathContainsValue(true);
                    it.enqueue(ContentMirrorStoreStrategy.this.getChildNodeEntries(index).iterator());
                } else {
                    for (String p : values) {
                        NodeState property = index.getChildNode(p);
                        if (!property.exists()) continue;
                        it.enqueue((Iterator<? extends ChildNodeEntry>)Iterators.singletonIterator((Object)new MemoryChildNodeEntry("", property)));
                    }
                }
                return it;
            }
        };
    }

    @Nonnull
    Iterable<? extends ChildNodeEntry> getChildNodeEntries(@Nonnull NodeState index) {
        return index.getChildNodeEntries();
    }

    @Override
    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, Iterable<String> values) {
        return this.query(filter, indexName, indexMeta, ":index", values);
    }

    @Override
    public long count(NodeState indexMeta, Set<String> values, int max) {
        return this.count(indexMeta, ":index", values, max);
    }

    public long count(NodeState indexMeta, String indexStorageNodeName, Set<String> values, int max) {
        NodeState index = indexMeta.getChildNode(indexStorageNodeName);
        int count = 0;
        if (values == null) {
            PropertyState ec = indexMeta.getProperty("entryCount");
            if (ec != null) {
                return ec.getValue(Type.LONG);
            }
            CountingNodeVisitor v = new CountingNodeVisitor(max);
            v.visit(index);
            count = v.getEstimatedCount();
            count *= 10;
        } else {
            int size = values.size();
            if (size == 0) {
                return 0L;
            }
            max = Math.max(10, max / size);
            int i = 0;
            for (String p : values) {
                if (count > max && i > 3) {
                    count = count * size / i;
                    break;
                }
                NodeState s = index.getChildNode(p);
                if (s.exists()) {
                    CountingNodeVisitor v = new CountingNodeVisitor(max);
                    v.visit(s);
                    count += v.getEstimatedCount();
                }
                ++i;
            }
        }
        return count;
    }

    NodeBuilder fetchKeyNode(@Nonnull NodeBuilder index, @Nonnull String key) {
        return index.child(key);
    }

    void prune(NodeBuilder index, Deque<NodeBuilder> builders) {
        for (NodeBuilder node : builders) {
            if (node.getBoolean("match") || node.getChildNodeCount(1L) > 0L) {
                return;
            }
            if (!node.exists()) continue;
            node.remove();
        }
    }

    static class CountingNodeVisitor
    implements NodeVisitor {
        final int maxCount;
        int count;
        int depth;
        long depthTotal;

        CountingNodeVisitor(int maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public void visit(NodeState state) {
            if (state.hasProperty("match")) {
                ++this.count;
                this.depthTotal += (long)this.depth;
            }
            if (this.count < this.maxCount) {
                ++this.depth;
                for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
                    if (this.count >= this.maxCount) break;
                    this.visit(childNodeEntry.getNodeState());
                }
                --this.depth;
            }
        }

        int getCount() {
            return this.count;
        }

        int getEstimatedCount() {
            if (this.count < this.maxCount) {
                return this.count;
            }
            double averageDepth = (int)(this.depthTotal / (long)this.count);
            long estimatedNodes = (long)((double)this.count * Math.pow(1.1, averageDepth));
            estimatedNodes = Math.min(estimatedNodes, Integer.MAX_VALUE);
            return Math.max(this.count, (int)estimatedNodes);
        }
    }

    static interface NodeVisitor {
        public void visit(NodeState var1);
    }

    static class PathIterator
    implements Iterator<String> {
        private final Filter filter;
        private final String indexName;
        private final Deque<Iterator<? extends ChildNodeEntry>> nodeIterators = Queues.newArrayDeque();
        private int readCount;
        private boolean init;
        private boolean closed;
        private String parentPath;
        private String currentPath;
        private boolean pathContainsValue;
        private final Set<String> knownPaths = Sets.newHashSet();
        private final long maxMemoryEntries;

        PathIterator(Filter filter, String indexName) {
            this.filter = filter;
            this.indexName = indexName;
            this.parentPath = "";
            this.currentPath = "/";
            this.maxMemoryEntries = filter.getQueryEngineSettings().getLimitInMemory();
        }

        void enqueue(Iterator<? extends ChildNodeEntry> it) {
            this.nodeIterators.addLast(it);
        }

        void setPathContainsValue(boolean pathContainsValue) {
            if (this.init) {
                throw new IllegalStateException("This iterator is already initialized");
            }
            this.pathContainsValue = pathContainsValue;
        }

        @Override
        public boolean hasNext() {
            if (!this.closed && !this.init) {
                this.fetchNext();
                this.init = true;
            }
            return !this.closed;
        }

        private void fetchNext() {
            do {
                this.fetchNextPossiblyDuplicate();
                if (this.closed) {
                    return;
                }
                if (!this.pathContainsValue) break;
                String value = (String)PathUtils.elements((String)this.currentPath).iterator().next();
                this.currentPath = PathUtils.relativize((String)value, (String)this.currentPath);
            } while (!this.knownPaths.add(this.currentPath));
        }

        private void fetchNextPossiblyDuplicate() {
            while (!this.nodeIterators.isEmpty()) {
                Iterator<? extends ChildNodeEntry> iterator = this.nodeIterators.getLast();
                if (iterator.hasNext()) {
                    ChildNodeEntry entry = iterator.next();
                    ++this.readCount;
                    if (this.readCount % 1000 == 0) {
                        FilterIterators.checkReadLimit(this.readCount, this.maxMemoryEntries);
                        LOG.warn("Traversed " + this.readCount + " nodes using index " + this.indexName + " with filter " + this.filter);
                    }
                    NodeState node = entry.getNodeState();
                    String name = entry.getName();
                    if (NodeStateUtils.isHidden(name)) continue;
                    this.currentPath = PathUtils.concat((String)this.parentPath, (String)name);
                    this.nodeIterators.addLast(node.getChildNodeEntries().iterator());
                    this.parentPath = this.currentPath;
                    if (!node.getBoolean("match")) continue;
                    return;
                }
                this.nodeIterators.removeLast();
                this.parentPath = PathUtils.getParentPath((String)this.parentPath);
            }
            this.currentPath = null;
            this.closed = true;
        }

        @Override
        public String next() {
            if (this.closed) {
                throw new IllegalStateException("This iterator is closed");
            }
            if (!this.init) {
                this.fetchNext();
                this.init = true;
            }
            String result = this.currentPath;
            this.fetchNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

