/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;

public final class RecordId
implements Comparable<RecordId> {
    public static RecordId[] EMPTY_ARRAY = new RecordId[0];
    private final SegmentId segmentId;
    private final int offset;

    public static RecordId fromString(SegmentTracker factory, String id) {
        int colon = id.indexOf(58);
        if (colon != -1) {
            UUID uuid = UUID.fromString(id.substring(0, colon));
            return new RecordId(factory.getSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()), Integer.parseInt(id.substring(colon + 1)));
        }
        throw new IllegalArgumentException("Bad RecordId: " + id);
    }

    public RecordId(SegmentId segmentId, int offset) {
        Preconditions.checkArgument((offset < 262144 ? 1 : 0) != 0);
        Preconditions.checkArgument(((offset & 3) == 0 ? 1 : 0) != 0);
        this.segmentId = (SegmentId)Preconditions.checkNotNull((Object)segmentId);
        this.offset = offset;
    }

    public SegmentId getSegmentId() {
        return this.segmentId;
    }

    public int getOffset() {
        return this.offset;
    }

    public Segment getSegment() {
        return this.segmentId.getSegment();
    }

    @Override
    public int compareTo(RecordId that) {
        Preconditions.checkNotNull((Object)that);
        int diff = this.segmentId.compareTo(that.segmentId);
        if (diff == 0) {
            diff = this.offset - that.offset;
        }
        return diff;
    }

    public String toString() {
        return this.segmentId + ":" + this.offset;
    }

    public int hashCode() {
        return this.segmentId.hashCode() ^ this.offset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RecordId) {
            RecordId that = (RecordId)object;
            return this.offset == that.offset && this.segmentId.equals(that.segmentId);
        }
        return false;
    }
}

