/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class AndImpl
extends ConstraintImpl {
    private ConstraintImpl constraint1;
    private ConstraintImpl constraint2;

    public AndImpl(ConstraintImpl constraint1, ConstraintImpl constraint2) {
        this.constraint1 = constraint1;
        this.constraint2 = constraint2;
    }

    public ConstraintImpl getConstraint1() {
        return this.constraint1;
    }

    public ConstraintImpl getConstraint2() {
        return this.constraint2;
    }

    @Override
    public ConstraintImpl simplify() {
        this.constraint1 = this.constraint1.simplify();
        this.constraint2 = this.constraint2.simplify();
        if (this.constraint1.equals(this.constraint2)) {
            return this.constraint1;
        }
        return this;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        Set<PropertyExistenceImpl> s1 = this.constraint1.getPropertyExistenceConditions();
        Set<PropertyExistenceImpl> s2 = this.constraint2.getPropertyExistenceConditions();
        HashSet result = Sets.newHashSet(s1);
        result.addAll(s2);
        return result;
    }

    @Override
    public FullTextExpression getFullTextConstraint(SelectorImpl s) {
        FullTextExpression f1 = this.constraint1.getFullTextConstraint(s);
        FullTextExpression f2 = this.constraint2.getFullTextConstraint(s);
        if (f1 == null) {
            return f2;
        }
        if (f2 == null) {
            return f1;
        }
        ArrayList<FullTextExpression> list = new ArrayList<FullTextExpression>();
        list.add(f1);
        list.add(f2);
        return new FullTextAnd(list);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        Set<SelectorImpl> s1 = this.constraint1.getSelectors();
        Set<SelectorImpl> s2 = this.constraint1.getSelectors();
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        return Sets.union(s1, s2);
    }

    @Override
    public Map<DynamicOperandImpl, Set<StaticOperandImpl>> getInMap() {
        Map<DynamicOperandImpl, Set<StaticOperandImpl>> m1 = this.constraint1.getInMap();
        Map<DynamicOperandImpl, Set<StaticOperandImpl>> m2 = this.constraint2.getInMap();
        if (m1.isEmpty()) {
            return m2;
        }
        if (m2.isEmpty()) {
            return m1;
        }
        HashMap result = Maps.newHashMap();
        result.putAll(m1);
        for (Map.Entry<DynamicOperandImpl, Set<StaticOperandImpl>> e2 : m2.entrySet()) {
            Set s = (Set)result.get(e2.getKey());
            if (s != null) {
                s.retainAll((Collection)e2.getValue());
                continue;
            }
            result.put(e2.getKey(), e2.getValue());
        }
        return result;
    }

    @Override
    public boolean evaluate() {
        return this.constraint1.evaluate() && this.constraint2.evaluate();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.protect(this.constraint1) + " and " + this.protect(this.constraint2);
    }

    @Override
    public void restrict(FilterImpl f) {
        this.constraint1.restrict(f);
        this.constraint2.restrict(f);
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        this.constraint1.restrictPushDown(s);
        this.constraint2.restrictPushDown(s);
    }
}

