/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.CredentialsCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.RepositoryCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.WhiteboardCallback;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

class CallbackHandlerImpl
implements CallbackHandler {
    private final Credentials credentials;
    private final String workspaceName;
    private final ContentRepository contentRepository;
    private final SecurityProvider securityProvider;
    private final Whiteboard whiteboard;

    CallbackHandlerImpl(Credentials credentials, String workspaceName, ContentRepository contentRepository, SecurityProvider securityProvider, Whiteboard whiteboard) {
        this.credentials = credentials;
        this.workspaceName = workspaceName;
        this.contentRepository = contentRepository;
        this.securityProvider = securityProvider;
        this.whiteboard = whiteboard;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CredentialsCallback) {
                ((CredentialsCallback)callback).setCredentials(this.credentials);
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.getName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.getPassword());
                continue;
            }
            if (callback instanceof RepositoryCallback) {
                RepositoryCallback repositoryCallback = (RepositoryCallback)callback;
                repositoryCallback.setContentRepository(this.contentRepository);
                repositoryCallback.setSecurityProvider(this.securityProvider);
                repositoryCallback.setWorkspaceName(this.workspaceName);
                continue;
            }
            if (callback instanceof WhiteboardCallback) {
                ((WhiteboardCallback)callback).setWhiteboard(this.whiteboard);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private String getName() {
        if (this.credentials instanceof SimpleCredentials) {
            return ((SimpleCredentials)this.credentials).getUserID();
        }
        return null;
    }

    private char[] getPassword() {
        if (this.credentials instanceof SimpleCredentials) {
            return ((SimpleCredentials)this.credentials).getPassword();
        }
        return null;
    }
}

