/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.Text;

final class PermissionEntry
implements Comparable<PermissionEntry>,
PermissionConstants {
    final boolean isAllow;
    final PrivilegeBits privilegeBits;
    private final int index;
    private final String path;
    final RestrictionPattern restriction;

    PermissionEntry(String path, Tree entryTree, RestrictionProvider restrictionsProvider) {
        this.path = path;
        this.isAllow = entryTree.getProperty("rep:isAllow").getValue(Type.BOOLEAN);
        this.index = Integer.parseInt(entryTree.getName());
        this.privilegeBits = PrivilegeBits.getInstance(entryTree.getProperty("rep:privileges"));
        this.restriction = restrictionsProvider.getPattern(path, entryTree);
    }

    static void write(NodeBuilder parent, boolean isAllow, int index, PrivilegeBits privilegeBits, Set<Restriction> restrictions) {
        NodeBuilder n = parent.child(String.valueOf(index)).setProperty("jcr:primaryType", "rep:Permissions", Type.NAME).setProperty("rep:isAllow", isAllow).setProperty(privilegeBits.asPropertyState("rep:privileges"));
        for (Restriction restriction : restrictions) {
            n.setProperty(restriction.getProperty());
        }
    }

    public boolean matches(@Nonnull Tree tree, @Nullable PropertyState property) {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(tree, property);
    }

    public boolean matches(@Nonnull String treePath) {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(treePath);
    }

    public boolean matches() {
        return this.restriction == RestrictionPattern.EMPTY || this.restriction.matches();
    }

    public boolean matchesParent(@Nonnull String parentPath) {
        return Text.isDescendantOrEqual((String)this.path, (String)parentPath) && (this.restriction == RestrictionPattern.EMPTY || this.restriction.matches(parentPath));
    }

    @Override
    public int compareTo(PermissionEntry pe) {
        int otherDepth;
        if (Objects.equal((Object)this.path, (Object)pe.path)) {
            if (this.index == pe.index) {
                return 0;
            }
            if (this.index < pe.index) {
                return 1;
            }
            return -1;
        }
        int depth = PathUtils.getDepth((String)this.path);
        if (depth == (otherDepth = PathUtils.getDepth((String)pe.path))) {
            return this.path.compareTo(pe.path);
        }
        return depth < otherDepth ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PermissionEntry) {
            PermissionEntry that = (PermissionEntry)o;
            return this.index == that.index && this.isAllow == that.isAllow && this.privilegeBits.equals(that.privilegeBits) && this.path.equals(that.path) && this.restriction.equals(that.restriction);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.privilegeBits, this.index, this.path, this.isAllow, this.restriction});
    }
}

