/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroupPredicate
implements Predicate<Authorizable> {
    static final Logger log = LoggerFactory.getLogger(GroupPredicate.class);
    private final Group group;
    private final boolean declaredMembersOnly;

    GroupPredicate(UserManager userManager, String groupId, boolean declaredMembersOnly) throws RepositoryException {
        Authorizable authorizable = userManager.getAuthorizable(groupId);
        this.group = authorizable == null || !authorizable.isGroup() ? null : (Group)authorizable;
        this.declaredMembersOnly = declaredMembersOnly;
    }

    public boolean apply(@Nullable Authorizable authorizable) {
        if (this.group != null && authorizable != null) {
            try {
                return this.declaredMembersOnly ? this.group.isDeclaredMember(authorizable) : this.group.isMember(authorizable);
            }
            catch (RepositoryException e) {
                log.debug("Cannot determine group membership for {}", (Object)authorizable, (Object)e.getMessage());
            }
        }
        return false;
    }
}

