/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.ancestor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.dom.TextNode;

public class TextOnlyComparator
implements IRangeComparator {
    private List<TextNode> leafs = new ArrayList<TextNode>();

    public TextOnlyComparator(TagNode tagNode) {
        this.addRecursive(tagNode);
    }

    private void addRecursive(TagNode tagNode) {
        for (Node node : tagNode) {
            Node node2;
            if (node instanceof TagNode) {
                node2 = (TagNode)node;
                this.addRecursive((TagNode)node2);
                continue;
            }
            if (!(node instanceof TextNode)) continue;
            node2 = (TextNode)node;
            this.leafs.add((TextNode)node2);
        }
    }

    public int getRangeCount() {
        return this.leafs.size();
    }

    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        TextOnlyComparator textOnlyComparator;
        try {
            textOnlyComparator = (TextOnlyComparator)iRangeComparator;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.getLeaf(n).isSameText(textOnlyComparator.getLeaf(n2));
    }

    private TextNode getLeaf(int n) {
        return this.leafs.get(n);
    }

    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        return false;
    }

    public double getMatchRatio(TextOnlyComparator textOnlyComparator) {
        LCSSettings lCSSettings = new LCSSettings();
        lCSSettings.setUseGreedyMethod(true);
        lCSSettings.setPowLimit(1.5);
        lCSSettings.setTooLong(22500.0);
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(lCSSettings, textOnlyComparator, this);
        int n = 0;
        for (RangeDifference rangeDifference : rangeDifferenceArray) {
            n += rangeDifference.leftLength();
        }
        int n2 = 0;
        for (RangeDifference rangeDifference : rangeDifferenceArray) {
            n2 += rangeDifference.rightLength();
        }
        return ((0.0 + (double)n) / (double)textOnlyComparator.getRangeCount() + (0.0 + (double)n2) / (double)this.getRangeCount()) / 2.0;
    }
}

