/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import jodd.typeconverter.Convert;
import jodd.typeconverter.TypeConverterManager;

public class DbUtil {
    public static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static long getFirstLong(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getLong(1);
        }
        return -1L;
    }

    public static int getFirstInt(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        return -1;
    }

    public static void setPreparedStatementObject(PreparedStatement preparedStatement, int index, Object value, int targetSqlType) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 0);
        }
        switch (targetSqlType) {
            case 12: {
                preparedStatement.setString(index, Convert.toString(value));
                break;
            }
            case 2: 
            case 4: {
                preparedStatement.setInt(index, Convert.toIntValue(value));
                break;
            }
            case 5: {
                preparedStatement.setShort(index, Convert.toShortValue(value));
                break;
            }
            case -5: {
                preparedStatement.setLong(index, Convert.toLongValue(value));
                break;
            }
            case 16: {
                preparedStatement.setBoolean(index, Convert.toBooleanValue(value));
                break;
            }
            case 1: {
                preparedStatement.setString(index, String.valueOf(Convert.toCharValue(value)));
                break;
            }
            case 91: {
                preparedStatement.setDate(index, TypeConverterManager.convertType(value, Date.class));
                break;
            }
            case 3: 
            case 7: {
                preparedStatement.setDouble(index, Convert.toDoubleValue(value));
                break;
            }
            case 6: {
                preparedStatement.setFloat(index, Convert.toFloatValue(value));
                break;
            }
            case 92: {
                preparedStatement.setTime(index, TypeConverterManager.convertType(value, Time.class));
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(index, TypeConverterManager.convertType(value, Timestamp.class));
                break;
            }
            default: {
                preparedStatement.setObject(index, value, targetSqlType);
            }
        }
    }
}

