/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImageStack;
import ij.macro.Interpreter;
import ij.process.ImageProcessor;

public class StackProcessor {
    private ImageStack stack;
    private ImageProcessor ip;
    int nSlices;
    double xScale;
    double yScale;
    int[] table;
    double fillValue;
    static final int FLIPH = 0;
    static final int FLIPV = 1;
    static final int SCALE = 2;
    static final int INVERT = 3;
    static final int APPLY_TABLE = 4;
    static final int SCALE_WITH_FILL = 5;

    public StackProcessor(ImageStack stack, ImageProcessor ip) {
        this.stack = stack;
        this.ip = ip;
        this.nSlices = stack.getSize();
        if (this.nSlices > 1 && ip != null) {
            ip.setProgressBar(null);
        }
    }

    void process(int command) {
        String s = "";
        ImageProcessor ip2 = this.stack.getProcessor(1);
        switch (command) {
            case 0: 
            case 1: {
                s = "Flip: ";
                break;
            }
            case 2: {
                s = "Scale: ";
                break;
            }
            case 5: {
                s = "Scale: ";
                ip2.setBackgroundValue(this.fillValue);
                break;
            }
            case 3: {
                s = "Invert: ";
                break;
            }
            case 4: {
                s = "Apply: ";
            }
        }
        ip2.setRoi(this.ip.getRoi());
        ip2.setInterpolate(this.ip.getInterpolate());
        for (int i = 1; i <= this.nSlices; ++i) {
            this.showStatus(s, i, this.nSlices);
            ip2.setPixels(this.stack.getPixels(i));
            if (this.nSlices == 1 && i == 1 && command == 2) {
                ip2.snapshot();
            }
            switch (command) {
                case 0: {
                    ip2.flipHorizontal();
                    break;
                }
                case 1: {
                    ip2.flipVertical();
                    break;
                }
                case 2: 
                case 5: {
                    ip2.scale(this.xScale, this.yScale);
                    break;
                }
                case 3: {
                    ip2.invert();
                    break;
                }
                case 4: {
                    ip2.applyTable(this.table);
                }
            }
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
    }

    public void invert() {
        this.process(3);
    }

    public void flipHorizontal() {
        this.process(0);
    }

    public void flipVertical() {
        this.process(1);
    }

    public void applyTable(int[] table) {
        this.table = table;
        this.process(4);
    }

    public void scale(double xScale, double yScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.process(2);
    }

    public void scale(double xScale, double yScale, double fillValue) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.fillValue = fillValue;
        this.process(5);
    }

    public ImageStack resize(int newWidth, int newHeight) {
        return this.resize(newWidth, newHeight, false);
    }

    public ImageStack resize(int newWidth, int newHeight, boolean averageWhenDownsizing) {
        ImageStack stack2 = new ImageStack(newWidth, newHeight);
        try {
            for (int i = 1; i <= this.nSlices; ++i) {
                this.showStatus("Resize: ", i, this.nSlices);
                this.ip.setPixels(this.stack.getPixels(1));
                String label = this.stack.getSliceLabel(1);
                this.stack.deleteSlice(1);
                ImageProcessor ip2 = this.ip.resize(newWidth, newHeight, averageWhenDownsizing);
                if (ip2 != null) {
                    stack2.addSlice(label, ip2);
                }
                IJ.showProgress((double)i / (double)this.nSlices);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            while (this.stack.getSize() > 1) {
                this.stack.deleteLastSlice();
            }
            IJ.outOfMemory("StackProcessor.resize");
            IJ.showProgress(1.0);
        }
        return stack2;
    }

    public ImageStack crop(int x, int y, int width, int height) {
        ImageStack stack2 = new ImageStack(width, height);
        for (int i = 1; i <= this.nSlices; ++i) {
            ImageProcessor ip1 = this.stack.getProcessor(1);
            ip1.setRoi(x, y, width, height);
            String label = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor ip2 = ip1.crop();
            stack2.addSlice(label, ip2);
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
        return stack2;
    }

    ImageStack rotate90Degrees(boolean clockwise) {
        ImageStack stack2 = new ImageStack(this.stack.getHeight(), this.stack.getWidth());
        for (int i = 1; i <= this.nSlices; ++i) {
            this.showStatus("Rotate: ", i, this.nSlices);
            this.ip.setPixels(this.stack.getPixels(1));
            String label = this.stack.getSliceLabel(1);
            this.stack.deleteSlice(1);
            ImageProcessor ip2 = clockwise ? this.ip.rotateRight() : this.ip.rotateLeft();
            if (ip2 != null) {
                stack2.addSlice(label, ip2);
            }
            if (Interpreter.isBatchMode()) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        if (!Interpreter.isBatchMode()) {
            IJ.showProgress(1.0);
        }
        return stack2;
    }

    public ImageStack rotateRight() {
        return this.rotate90Degrees(true);
    }

    public ImageStack rotateLeft() {
        return this.rotate90Degrees(false);
    }

    public void copyBits(ImageProcessor src, int xloc, int yloc, int mode) {
        this.copyBits(src, null, xloc, yloc, mode);
    }

    public void copyBits(ImageStack src, int xloc, int yloc, int mode) {
        this.copyBits(null, src, xloc, yloc, mode);
    }

    private void copyBits(ImageProcessor srcIp, ImageStack srcStack, int xloc, int yloc, int mode) {
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        boolean stackSource = srcIp == null;
        for (int i = 1; i <= this.nSlices; ++i) {
            if (stackSource) {
                srcIp = srcStack.getProcessor(i);
            }
            ImageProcessor dstIp = this.stack.getProcessor(i);
            dstIp.copyBits(srcIp, xloc, yloc, mode);
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
        }
        IJ.showProgress(1.0);
    }

    void showStatus(String s, int n, int total) {
        IJ.showStatus(s + n + "/" + total);
    }
}

