/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.model.impl.BookmarksFolderBaseImpl;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class BookmarksFolderImpl
extends BookmarksFolderBaseImpl {
    public List<Long> getAncestorFolderIds() throws PortalException, SystemException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        BookmarksFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestorFolderIds.add(folder.getFolderId());
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestorFolderIds;
    }

    public List<BookmarksFolder> getAncestors() throws PortalException, SystemException {
        ArrayList<BookmarksFolder> ancestors = new ArrayList<BookmarksFolder>();
        BookmarksFolderImpl folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestors.add(folder);
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestors;
    }

    public BookmarksFolder getParentFolder() throws PortalException, SystemException {
        if (this.getParentFolderId() == 0L) {
            return null;
        }
        return BookmarksFolderLocalServiceUtil.getFolder((long)this.getParentFolderId());
    }

    public boolean isInTrashExplicitly() throws SystemException {
        if (!this.isInTrash()) {
            return false;
        }
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)this.getModelClassName(), (long)this.getTrashEntryClassPK());
        return trashEntry != null;
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }
}

