/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.InvokerPortletImpl;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class UpdateLookAndFeelAction
extends JSONAction {
    private static Log _log = LogFactoryUtil.getLog(UpdateLookAndFeelAction.class);

    @Override
    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletId;
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)(portletId = ParamUtil.getString((HttpServletRequest)request, (String)"portletId")), (String)"CONFIGURATION")) {
            return null;
        }
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup((Layout)layout, (String)portletId);
        String css = ParamUtil.getString((HttpServletRequest)request, (String)"css");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating css " + css));
        }
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject((String)css);
        JSONObject portletData = jsonObj.getJSONObject("portletData");
        jsonObj.remove("portletData");
        css = jsonObj.toString();
        boolean useCustomTitle = portletData.getBoolean("useCustomTitle");
        String showBorders = portletData.getString("showBorders");
        String linkToLayoutUuid = GetterUtil.getString((String)portletData.getString("portletLinksTarget"));
        JSONObject titles = portletData.getJSONObject("titles");
        Locale[] locales = LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId());
        int i2 = 0;
        while (i2 < locales.length) {
            String languageId = LocaleUtil.toLanguageId((Locale)locales[i2]);
            String title = null;
            if (titles.has(languageId)) {
                title = GetterUtil.getString((String)titles.getString(languageId));
            }
            if (Validator.isNotNull(title)) {
                portletSetup.setValue("portletSetupTitle_" + languageId, title);
            } else {
                portletSetup.reset("portletSetupTitle_" + languageId);
            }
            ++i2;
        }
        portletSetup.setValue("portletSetupUseCustomTitle", String.valueOf(useCustomTitle));
        if (Validator.isNotNull((String)showBorders)) {
            boolean showBordersBoolean = portletData.getBoolean("showBorders");
            portletSetup.setValue("portletSetupShowBorders", String.valueOf(showBordersBoolean));
        } else {
            portletSetup.reset("portletSetupShowBorders");
        }
        if (Validator.isNotNull((String)linkToLayoutUuid)) {
            portletSetup.setValue("portletSetupLinkToLayoutUuid", linkToLayoutUuid);
        } else {
            portletSetup.reset("portletSetupLinkToLayoutUuid");
        }
        portletSetup.setValue("portletSetupCss", css);
        if (PropsValues.MOBILE_DEVICE_STYLING_WAP_ENABLED) {
            JSONObject wapData = jsonObj.getJSONObject("wapData");
            String wapInitialWindowState = wapData.getString("initialWindowState");
            String wapTitle = wapData.getString("title");
            portletSetup.setValue("lfrWapInitialWindowState", wapInitialWindowState);
            portletSetup.setValue("lfrWapTitle", wapTitle);
        } else {
            portletSetup.reset("lfrWapInitialWindowState");
            portletSetup.reset("lfrWapTitle");
        }
        portletSetup.store();
        InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portletId, LanguageUtil.getLanguageId((HttpServletRequest)request));
        return null;
    }
}

