/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.parser.AbstractParser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JAMWikiPostProcessor;
import org.jamwiki.parser.jflex.JAMWikiPreProcessor;
import org.jamwiki.parser.jflex.JAMWikiProcessor;
import org.jamwiki.parser.jflex.JAMWikiSpliceProcessor;
import org.jamwiki.parser.jflex.JAMWikiTemplateProcessor;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

public class JFlexParser
extends AbstractParser {
    private static final WikiLogger logger = WikiLogger.getLogger(JFlexParser.class.getName());
    private static final int TIME_LIMIT_PARSE = 15;
    public static final int MODE_SPLICE = 1;
    public static final int MODE_SLICE = 2;
    public static final int MODE_MINIMAL = 3;
    public static final int MODE_TEMPLATE_BODY = 4;
    public static final int MODE_TEMPLATE = 5;
    public static final int MODE_PREPROCESS = 6;
    public static final int MODE_PROCESS = 7;
    public static final int MODE_LAYOUT = 8;
    public static final int MODE_POSTPROCESS = 9;
    private static final Pattern REDIRECT_PATTERN = Pattern.compile("#REDIRECT[ ]*\\[\\[([^\\n\\r\\]]+)\\]\\]", 2);

    public JFlexParser(ParserInput parserInput) {
        super(parserInput);
    }

    public String buildRedirectContent(String topicName) {
        return "#REDIRECT [[" + topicName + "]]";
    }

    protected String isRedirect(String raw) throws ParserException {
        if (StringUtils.isBlank((String)raw)) {
            return null;
        }
        Matcher m = REDIRECT_PATTERN.matcher(raw.trim());
        return m.matches() ? Utilities.decodeAndEscapeTopicName(m.group(1).trim(), true) : null;
    }

    private String lex(JFlexLexer lexer, String raw, ParserOutput parserOutput, int mode) throws ParserException {
        lexer.init(this.parserInput, parserOutput, mode);
        JFlexParser.validate(lexer);
        this.parserInput.incrementDepth();
        long current = 0L;
        try {
            String line;
            long previous = System.currentTimeMillis();
            while ((line = lexer.yylex()) != null) {
                lexer.append(line);
                current = System.currentTimeMillis();
                if (logger.isDebugEnabled() && current - previous > 15L) {
                    String message = "Slow parsing (" + (double)(current - previous) / 1000.0 + " s) for topic: " + this.parserInput.getTopicName() + " / state: " + lexer.yystate();
                    if (raw != null && raw.length() < 300) {
                        message = message + " / content: " + raw;
                    }
                    logger.debug(message);
                }
                previous = current;
            }
        }
        catch (Exception e) {
            this.parserInput.decrementDepth();
            throw new ParserException("Failure while parsing topic " + this.parserInput.getTopicName(), e);
        }
        this.parserInput.decrementDepth();
        return lexer.popAllTags();
    }

    public String parseFragment(ParserOutput parserOutput, String raw, int mode) throws ParserException {
        String output = raw;
        int preMode = mode > 5 ? 5 : mode;
        output = this.parseTemplate(parserOutput, output, preMode);
        preMode = mode > 6 ? 6 : mode;
        output = this.parsePreProcess(parserOutput, output, preMode);
        preMode = mode > 7 ? 7 : mode;
        output = this.parseProcess(parserOutput, output, preMode);
        return output;
    }

    public String parseHTML(ParserOutput parserOutput, String raw) throws ParserException {
        long start = System.currentTimeMillis();
        String output = raw + '\n';
        output = this.parseTemplate(parserOutput, output, 5);
        output = this.parsePreProcess(parserOutput, output, 6);
        output = this.parseProcess(parserOutput, output, 8);
        output = this.parsePostProcess(parserOutput, output, 9);
        if (!StringUtils.isBlank((String)parserOutput.getRedirect())) {
            output = this.parseRedirect(parserOutput, raw);
        }
        String topicName = !StringUtils.isBlank((String)this.parserInput.getTopicName()) ? this.parserInput.getTopicName() : null;
        logger.info("Parse time (parseHTML) for " + topicName + " (" + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.)");
        return output;
    }

    public void parseMetadata(ParserOutput parserOutput, String raw) throws ParserException {
        long start = System.currentTimeMillis();
        if (this.parserInput.getContext() == null) {
            this.parserInput.setContext("/wiki");
        }
        String output = raw + '\n';
        output = this.parseTemplate(parserOutput, output, 5);
        output = this.parsePreProcess(parserOutput, output, 6);
        if (logger.isInfoEnabled()) {
            String topicName = !StringUtils.isBlank((String)this.parserInput.getTopicName()) ? this.parserInput.getTopicName() : null;
            logger.info("Parse time (parseMetadata) for " + topicName + " (" + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.)");
        }
    }

    public String parseMinimal(String raw) throws ParserException {
        long start = System.currentTimeMillis();
        String output = raw;
        ParserOutput parserOutput = new ParserOutput();
        output = this.parseTemplate(parserOutput, output, 3);
        String topicName = !StringUtils.isBlank((String)this.parserInput.getTopicName()) ? this.parserInput.getTopicName() : null;
        logger.info("Parse time (parseHTML) for " + topicName + " (" + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.)");
        return output;
    }

    private String parseTemplate(ParserOutput parserOutput, String raw, int mode) throws ParserException {
        StringReader reader = this.toStringReader(raw);
        JAMWikiTemplateProcessor lexer = new JAMWikiTemplateProcessor(reader);
        int preMode = mode > 5 ? 5 : mode;
        return this.lex(lexer, raw, parserOutput, preMode);
    }

    private String parsePreProcess(ParserOutput parserOutput, String raw, int mode) throws ParserException {
        int preMode;
        if (mode < 6) {
            return raw;
        }
        StringReader reader = this.toStringReader(raw);
        JAMWikiPreProcessor lexer = new JAMWikiPreProcessor(reader);
        String result = this.lex(lexer, raw, parserOutput, preMode = mode > 6 ? 6 : mode);
        String redirect = this.isRedirect(result);
        if (!StringUtils.isBlank((String)redirect)) {
            boolean colon;
            boolean bl = colon = redirect.length() > 1 && redirect.charAt(0) == ':';
            if (colon) {
                redirect = redirect.substring(1);
            }
            parserOutput.setRedirect(redirect);
        }
        return result;
    }

    private String parseProcess(ParserOutput parserOutput, String raw, int mode) throws ParserException {
        if (mode < 7) {
            return raw;
        }
        StringReader reader = this.toStringReader(raw);
        JAMWikiProcessor lexer = new JAMWikiProcessor(reader);
        return this.lex(lexer, raw, parserOutput, mode);
    }

    private String parsePostProcess(ParserOutput parserOutput, String raw, int mode) throws ParserException {
        if (mode < 9) {
            return raw;
        }
        StringReader reader = this.toStringReader(raw);
        JAMWikiPostProcessor lexer = new JAMWikiPostProcessor(reader);
        return this.lex(lexer, raw, parserOutput, mode);
    }

    protected String parseRedirect(ParserOutput parserOutput, String raw) throws ParserException {
        String preprocessed = JFlexParserUtil.parseFragment(this.parserInput, parserOutput, raw, 6);
        String redirect = this.isRedirect(preprocessed);
        WikiLink wikiLink = JFlexParserUtil.parseWikiLink(this.parserInput, parserOutput, "[[" + redirect + "]]");
        String style = "redirect";
        try {
            String virtualWiki = this.parserInput.getVirtualWiki();
            if (wikiLink.getVirtualWiki() != null) {
                virtualWiki = wikiLink.getVirtualWiki().getName();
            }
            if (LinkUtil.isExistingArticle(virtualWiki, wikiLink.getDestination()) == null) {
                style = "edit redirect";
            }
            return LinkUtil.buildInternalLinkHtml(this.parserInput.getContext(), virtualWiki, wikiLink, null, style, null, false);
        }
        catch (DataAccessException e) {
            throw new ParserException(e);
        }
    }

    public String parseSlice(ParserOutput parserOutput, String raw, int targetSection) throws ParserException {
        long start = System.currentTimeMillis();
        StringReader reader = this.toStringReader(raw);
        JAMWikiSpliceProcessor lexer = new JAMWikiSpliceProcessor(reader);
        lexer.setTargetSection(targetSection);
        String output = this.lex(lexer, raw, parserOutput, 2);
        String topicName = !StringUtils.isBlank((String)this.parserInput.getTopicName()) ? this.parserInput.getTopicName() : null;
        logger.debug("Parse time (parseSlice) for " + topicName + " (" + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.)");
        return output;
    }

    public String parseSplice(ParserOutput parserOutput, String raw, int targetSection, String replacementText) throws ParserException {
        long start = System.currentTimeMillis();
        StringReader reader = this.toStringReader(raw);
        JAMWikiSpliceProcessor lexer = new JAMWikiSpliceProcessor(reader);
        lexer.setReplacementText(replacementText);
        lexer.setTargetSection(targetSection);
        String output = this.lex(lexer, raw, parserOutput, 1);
        String topicName = !StringUtils.isBlank((String)this.parserInput.getTopicName()) ? this.parserInput.getTopicName() : null;
        logger.debug("Parse time (parseSplice) for " + topicName + " (" + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.)");
        return output;
    }

    private StringReader toStringReader(String raw) {
        return new StringReader(StringUtils.remove((String)raw, (char)'\r'));
    }

    private static void validate(JFlexLexer lexer) throws ParserException {
        boolean validated = true;
        if (lexer.mode == 1 || lexer.mode == 2) {
            if (lexer.parserInput.getTopicName() == null) {
                logger.info("Failure while initializing parser: topic name is null.");
                validated = false;
            }
        } else if (lexer.mode == 9) {
            if (lexer.parserInput == null) {
                logger.info("Failure while initializing parser: ParserInput is null.");
                validated = false;
            }
            if (lexer.parserInput.getTableOfContents() == null) {
                logger.info("Failure while initializing parser: table of contents object is null.");
                validated = false;
            }
        } else if (lexer.mode >= 7 && lexer.mode <= 8) {
            if (lexer.parserInput.getTableOfContents() == null) {
                logger.info("Failure while initializing parser: table of contents object is null.");
                validated = false;
            }
            if (lexer.parserInput.getTopicName() == null) {
                logger.info("Failure while initializing parser: topic name is null.");
                validated = false;
            }
            if (lexer.parserInput.getContext() == null) {
                logger.info("Failure while initializing parser: context is null.");
                validated = false;
            }
            if (lexer.parserInput.getVirtualWiki() == null) {
                logger.info("Failure while initializing parser: virtual wiki is null.");
                validated = false;
            }
        } else if (lexer.mode <= 6 && lexer.mode >= 3) {
            if (lexer.parserInput.getVirtualWiki() == null) {
                logger.info("Failure while initializing parser: virtual wiki is null.");
                validated = false;
            }
            if (lexer.parserInput.getTopicName() == null) {
                logger.info("Failure while initializing parser: topic name is null.");
                validated = false;
            }
        }
        if (!validated) {
            throw new ParserException("Parser info not properly initialized");
        }
    }
}

