/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.messaging.proxy.ProxyRequest;
import com.liferay.portal.kernel.messaging.proxy.ProxyResponse;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import java.util.Map;

public abstract class BaseProxyBean {
    private SingleDestinationMessageSender _singleDestinationMessageSender;
    private SingleDestinationSynchronousMessageSender _singleDestinationSynchronousMessageSender;

    public void send(ProxyRequest proxyRequest) {
        this._singleDestinationMessageSender.send(this.buildMessage(proxyRequest));
    }

    public void setSingleDestinationMessageSender(SingleDestinationMessageSender singleDestinationMessageSender) {
        this._singleDestinationMessageSender = singleDestinationMessageSender;
    }

    public void setSingleDestinationSynchronousMessageSender(SingleDestinationSynchronousMessageSender singleDestinationSynchronousMessageSender) {
        this._singleDestinationSynchronousMessageSender = singleDestinationSynchronousMessageSender;
    }

    public Object synchronousSend(ProxyRequest proxyRequest) throws Exception {
        ProxyResponse proxyResponse = (ProxyResponse)this._singleDestinationSynchronousMessageSender.send(this.buildMessage(proxyRequest));
        if (proxyResponse == null) {
            return proxyRequest.execute(this);
        }
        if (proxyResponse.hasError()) {
            throw proxyResponse.getException();
        }
        return proxyResponse.getResult();
    }

    protected Message buildMessage(ProxyRequest proxyRequest) {
        Message message = new Message();
        message.setPayload(proxyRequest);
        Map<String, Object> values = MessageValuesThreadLocal.getValues();
        if (!values.isEmpty()) {
            for (String key : values.keySet()) {
                message.put(key, values.get(key));
            }
        }
        if (proxyRequest.isLocal()) {
            message.put("LOCAL_MESSAGE", Boolean.TRUE);
        }
        return message;
    }
}

