/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;

public class HeapUtil {
    public static void heapDump(boolean live, boolean binary, String file) {
        int processId = HeapUtil._getProcessId();
        StringBundler sb = new StringBundler(5);
        sb.append("-dump:");
        if (live) {
            sb.append("live,");
        }
        if (binary) {
            sb.append("format=b,");
        }
        sb.append("file=");
        sb.append(file);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("jmap");
        arguments.add(sb.toString());
        arguments.add(String.valueOf(processId));
        try {
            ProcessUtil.execute(ProcessUtil.LOGGING_OUTPUT_PROCESSOR, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to perform heap dump", e);
        }
    }

    private static int _getProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeMXBean.getName();
        int index = name.indexOf(64);
        if (index == -1) {
            throw new RuntimeException("Unable to parse process name " + name);
        }
        int pid = GetterUtil.getInteger(name.substring(0, index));
        if (pid == 0) {
            throw new RuntimeException("Unable to parse process name " + name);
        }
        return pid;
    }
}

