/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.test;

import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.net.URI;
import java.util.ListIterator;
import java.util.concurrent.TimeoutException;

public class ReaderRandomIteratorThread
extends Thread {
    private URI locator = null;

    public ReaderRandomIteratorThread(URI locator) {
        this.locator = locator;
    }

    @Override
    public void run() {
        try {
            Field f;
            GenericRecord rec;
            RandomReader reader = new RandomReader(this.locator);
            System.out.println("starting reading");
            ListIterator iter = reader.listIterator();
            System.out.println("going forward");
            while (iter.hasNext()) {
                rec = (GenericRecord)iter.next();
                if (rec == null) {
                    throw new TimeoutException("Exception while waiting for record");
                }
                f = rec.getField("ThisIsTheField");
                if (f == null) continue;
                System.out.println(((StringField)f).getPayload());
            }
            System.out.println("going backward");
            while (iter.hasPrevious()) {
                rec = (GenericRecord)iter.previous();
                if (rec == null) {
                    throw new TimeoutException("Exception while waiting for record");
                }
                f = rec.getField("ThisIsTheField");
                if (f == null) continue;
                System.out.println(((StringField)f).getPayload());
            }
            System.out.println("going forward");
            while (iter.hasNext()) {
                rec = (GenericRecord)iter.next();
                if (rec == null) {
                    throw new TimeoutException("Exception while waiting for record");
                }
                f = rec.getField("ThisIsTheField");
                if (f == null) continue;
                System.out.println(((StringField)f).getPayload());
            }
            System.out.println("reader closing");
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

